                      ******************************
	           ******                        ******
                 ****          KILLING SPREE         ****
		****         STARTED ON 27-8-91       ****
                ****	    			      ****
                ****    CONCEPT BY STEFAN POSTHUMA,   ****
                ****	     TIM AND DAVE MOSS        ****
                ****	    CODING BY TIM MOSS        ****
                ****	    			      ****
                ****       (C) COPYRIGHT 1991 BY      ****
                ****       LOST BOYS DEVELOPMENT      ****
                 ****  		                     ****
                   ******                        ******
                      ******************************

*****************************************************************************
* 16-12-91 
*****************************************************************************

			OPT	O+
 
*****************************USEFUL EQUATES**********************************

MARKS:			EQU	0
FRAME_COUNTER:		EQU	1
VBL_COUNT:		EQU	3
MAX_ITEMS:		EQU	50
OBS_IN_DRAW_LIST:	EQU	30

DMA			EQU	0
	IFEQ	DMA
MEG			EQU	$180000   
	ELSEIF
MEG			EQU	$0
	ENDC

SCREEN1			EQU	$68900+MEG
SCREEN2			EQU	$70600+MEG
SCREEN3			EQU	$78300+MEG

GRID_SIZE		EQU	32
MAX_HEIGHT		EQU	130
Y_MIDDLE		EQU	88-32
CONTROL_PANEL_Y		EQU	200-32-3
SCORE_PANEL_Y:		EQU	0

**************************END OF USEFUL EQUATES******************************

	JMP	START

START_OF_DATA:
WATER_LEVEL:	DS.W	1
RANDOM_FAC:	DS.W	1
LAND_LEVEL:	DS.W	1
RANDOM_NUMBER:	DS.L	1
CREATION_STYLE:	DS.W	1			*0 = ISLANDS, 1 = CANYON, 2 = BLANK, 3 = DEEP CANYON
FILL_STYLES:	DS.W	1			*(1-4)
RIVER_HEIGHT:	DS.W	1			*ONLY APPLICABLE WHEN CANYON IS ACTIVATED
PALETTE:	DS.W	16
RASTERS:	DS.W	60
SHIP_START_X:	DS.W	1
SHIP_START_Z:	DS.W	1
FIRE_REPEAT:	DS.W	1
LEVEL_TIME:	DS.W	1
BACK_PALETTE:	DS.W	16
BACK_RASTERS:	DS.W	60
RASTER_COUNT:	DS.W	1
END_OF_DATA:
		DS.B	512-(END_OF_DATA-START_OF_DATA)
		DS.B	10			*PROBABLY UNECCESSARY
FILE_NAME:	DC.B	"N:\LANDGAME.TLB\MAPS\DEMO1.MAP",0
		EVEN

PANEL_PALETTE:	DC.W	$000,$003,$230,$340,$003,$004,$015,$125
		DC.W	$235,$346,$556,$400,$510,$620,$740,$762
		DC.W	$302,$403,$514,$625,$747

BACK_PANEL_PALETTE:
		DS.W	16+5

*IN THE BEGINNING THERE WAS NOTHING.................

START:
	CLR.L	-(SP)			SUPER VISOR CALL
	MOVE.W	#$20,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	MOVE.L	D0,OLDSSP
	LEA	OURSTACK,A7

	MOVEM.L	$FFFF8240.W,D0-D7	STORE STANDARD PALETTE
	MOVEM.L	D0-D7,OLD_PALETTE

	MOVE.W	#0,-(SP)		SWITCH INTO LOWRES
	MOVE.L	#-1,-(SP)
	MOVE.L	#-1,-(SP)
	MOVE.W	#5,-(SP)
	TRAP	#14
	ADD.L	#12,SP

	MOVEQ	#1,D7			NUMBER_OF_BYTES
	LEA	KEYBOARD_ON(PC),A0
	BSR 	IKBD

	BSR	CLEAR_SCREENS		ERASE DRAW AREA
	LEA	HELLO_TEXT,A0
	LEA	SCREEN1,A1
	JSR	PRINT_TEXT		PUT UP A LOAD OF TEXT
	MOVE.L	#SCREEN1,D0
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W
	ST	FADE_IN
	BSR	HBL_ON			SWITCH ON INTERRUPTS
	BSR	PREPARE_PROJ_DIVU	MAKE UP PROJECT AND DIVIDE TABLES
	BSR	PREPARE_GRID_MULT	MAKE UP MULTIPLE TABLE FOR GRIDS
	BSR	PREPARE_SIDES		MAKE UP SIDE ERASE ROUTS

	LEA	FILE_NAME(PC),A0	LOAD AND UNPACK FRACTAL DATA
	BSR	LOAD_FILE
	
	BCLR	#5,$FFFFFA09.W
	
	BSR	INIT_OBJECTS		SET UP DATA FOR SCREEN
	ST	FADE_OUT
.WAIT:	TST.B	FADE_OUT		
	BNE.S	.WAIT	
	BSR	CLEAR_SCREENS		ERASE DRAW AREA
	BSR	ADD_PLANE1_AND_PANEL	ADD EXTRA GFX TO TOP OF SCREEN

	MOVE.L	#VBL_1,$70.W		ALL SYSTEMS GO!
	ST	FADE_IN
	SF	FADE_OUT
	MOVE.W	#$4EB9,FADE_INSERT
	MOVE.L	#THE_FADE_ROUTINES,FADE_INSERT+2
MAIN_LOOP:
	ADDQ.W	#1,FRAME_VARS+2

	BSR	VSYNC

	LEA	LOGBASE(PC),A0		ROTATE SCREEN ADRESSES
	MOVEM.L	(A0)+,D0-D2
	MOVEM.L	D0-D1,-(A0)
	MOVE.L	D2,-(A0)
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W

FADE_INSERT:
	NOP				SPACE FOR JSR TO FADE ROUTS
	NOP
	NOP

	BSR	PLAYER_CONTROL_ROUT	READ JOYSTICK AND STUFF

	BSR	CLEAR_LOGBASE		CLEAR SCREEN AREA

	BSR	DO_CONTROL_PANEL	DRAW ALL RELEVANT STUFF ON CONTROL PANEL

	BSR	CALCULATE_GRID		CALCULATE POINTS

	BSR	MOVE_ALL_OBJECTS	DO OBJECT MOVEMENTS AND STUFF

	BSR	DRAW_3D_VERSION		DRAW OUT THE 3D VERSION ONTO LOGBASE

	BRA.S	MAIN_LOOP

CURRENT_X_VEL:	DC.W	0,0		
CURRENT_Y_VEL:	DC.W	0,0
CURRENT_POS_Z:	DC.W	$1C3,0		MAP POSITION Z
CURRENT_POS_X:	DC.W	3,0		MAP POSITION X
CURRENT_POS_Y:	DC.W	30,0		MAP POSITION Y
CURRENT_SHIP_X:	DC.W	8,$8000		SHIP POSITION X

Z_ACC:		DC.L	$0000		ALTERABLE CONSTANTS
X_ACC:		DC.L	$2800
X_DAMPING:	DC.L	$1000
Y_ACC:		DC.L	$36000
Y_DAMPING:	DC.L	$18000

TARGET_VELOCITY	DC.L	$0		
VEL_OVERRIDE:	DC.W	0		GAME SETS VELOCITY?
MOVE_OVERRIDE:	DC.W	0		IGNORE JOYSTICK COMMANDS
AUTOFIRE:	DC.W	0		AUTOFIRE 0=OFF 1= ON
SHIP_MODE:	DC.W	0		0 = NORMAL, 1 = EXPLODE
SHIP_X_REAL:	DC.W	0		REAL X POSITION

SCORE:		DC.L	0		0 SCORE TO START
ENERGY:		DC.W	111		FULL ENERGY
LIVES:		DC.W	5		3 LIVES

***********************************************
* THIS IS THE KEYBOARD VERSION OF THE CONTROL *
* ROUTINE.                                    *
***********************************************

ACC_TABLE:	DC.L	0,0,0,-$1000,-$3000,-$5000,-$7000
		DC.L	-$9000,-$B000,-$D000,-$E000,-$F000,-$10000

PLAYER_CONTROL_ROUT:
	MOVEM.L	CURRENT_X_VEL(PC),D0-D6		GET ALL MOVEMENT VARIABLES

	TST.B	VEL_OVERRIDE			TAKE NOTICE OF VELOCITY?
	BNE.S	.NO_ACC_CHANGE
	MOVEQ	#0,D7
	MOVE.B	KBUFF(PC),D7			GET KEY PRESS
	SUB.W	#$38,D7
	CMP.W	#12,D7
	BHI.S	.NO_ACC_CHANGE			IS IT A VELOCITY KEY?
	CLR.B	KBUFF
	ADD.W	D7,D7
	ADD.W	D7,D7				MOVE IT INTO TARGET VELOCITY
	MOVE.L	ACC_TABLE(PC,D7.W),TARGET_VELOCITY
.NO_ACC_CHANGE:
	CMP.L	TARGET_VELOCITY(PC),D6		ARE WE MOVING AT TARGET VEL?
	BEQ.S	.NO_CHANGE
	BGT.S	.LOSE_SOME
	ADD.L	#$800,D6			GAIN A BIT
	BRA.S	.NO_CHANGE
.LOSE_SOME:
	SUB.L	#$800,D6			LOSE A BIT
.NO_CHANGE:
	MOVE.L	D6,LAST_Z_MOVEMENT
	ADD.L	D6,D2				ADD Z ACCELERATION
	TST.L	D2				FIX END OF MAP BUGS
	BGT.S	.OK1
	ADD.L	#$2000000,D2			BACK TO START
	BRA.S	.OK2
.OK1:	CMP.L	#$2000000,D2			BACK TO BEGINNING
	BLT.S	.OK2
	SUB.L	#$2000000,D2
.OK2:
	MOVEQ	#0,D7
	MOVE.B	JBUFF0(PC),D7			GET JOYSTICK DATA!

	TST.L	D0				LEFT/RIGHT VELOCITIES 
	BEQ.S	.NO_AUTO_DECEL_X
	BMI.S	.D_2				LEFT VEL, SO DAMP RIGHT
	SUB.L	X_DAMPING(PC),D0
	BPL.S	.NO_AUTO_DECEL_X		STILL MOVING?
	MOVEQ	#0,D0				ENSURE VEL=0
	BRA.S	.NO_AUTO_DECEL_X
.D_2	ADD.L	X_DAMPING(PC),D0
	BMI.S	.NO_AUTO_DECEL_X		STILL  MOVING
	MOVEQ	#0,D0				ENSURE VEL=0
.NO_AUTO_DECEL_X
	TST.B	MOVE_OVERRIDE
	BNE.S	.NO_RIGHT_INC
	BTST	#2,D7				LEFT?
	BEQ.S	.NO_LEFT_INC
	CMP.L	#-$A000,D0			MAX LEFT VELOCITY?
	BGE.S	.STILL_ACCL
	SUB.L	X_DAMPING(PC),D0		MAINTAIN MAX VELOCITY
	BRA.S	.NO_LEFT_INC
.STILL_ACCL
	SUB.L	X_ACC(PC),D0
.NO_LEFT_INC:
	BTST	#3,D7				RIGHT?
	BEQ.S	.NO_RIGHT_INC
	CMP.L	#$A000,D0			MAX RIGHT VELOCITY?
	BLE.S	.STILL_ACCR
	ADD.L	X_DAMPING(PC),D0		MAINTAIN MAX VELOCITY
	BRA.S	.NO_RIGHT_INC
.STILL_ACCR
	ADD.L	X_ACC(PC),D0
.NO_RIGHT_INC:
	CMP.L	#$58000,D5			NEED TO TEST MAP MOVEMENTS?
	BLT.S	.STORE_EM
	CMP.L	#$1A8000,D5
	BGT.S	.STORE_EM
	ADD.L	D0,D3				OK ADD X VELOCITY
	TST.L	D3
	BMI.S	.NO_LEFT_A
	CMP.L	#$150000,D3			AT EDGES?
	BGE.S	.NO_RIGHT_A
	BRA.S	.STORE_EM
.NO_LEFT_A
	MOVEQ	#0,D3				IF SO THEN FIX POSITIONS
	BRA.S	.STORE_EM
.NO_RIGHT_A
	MOVE.L	#$150000,D3
.STORE_EM:
	ADD.L	D0,D5				ALSO ADD X VELOCITY TO SHIPS POSITION
	CMP.L	#$10000,D5			AND CHECK SHIP ISN'T OFFSCREEN
	BLE.S	.NO_LEFT_A2
	CMP.L	#$1F0000,D5
	BGE.S	.NO_RIGHT_A2
	BRA.S	.STORE_EM2
.NO_LEFT_A2:
	MOVEQ	#0,D0
	MOVE.L	#$10000,D5
	BRA.S	.STORE_EM2
.NO_RIGHT_A2:
	MOVEQ	#0,D0
	MOVE.L	#$1F0000,D5
.STORE_EM2:
	TST.L	D1				UP/DOWN VELOCITIES
	BEQ.S	.NO_AUTO_DECEL_Y
	BMI.S	.D_3
	SUB.L	Y_DAMPING(PC),D1
	BPL.S	.NO_AUTO_DECEL_Y
	MOVEQ	#0,D1
	BRA.S	.NO_AUTO_DECEL_Y
.D_3	ADD.L	Y_DAMPING(PC),D1
	BMI.S	.NO_AUTO_DECEL_Y
	MOVEQ	#0,D1
.NO_AUTO_DECEL_Y
	TST.B	MOVE_OVERRIDE
	BNE.S	.NO_DOWN_INC
	BTST	#1,D7				UP?
	BEQ.S	.NO_UP_INC
	CMP.L	#-$90000,D1
	BGE.S	.STILL_ACRU
	SUB.L	Y_DAMPING(PC),D1		MAINTAIN MAX VELOCITY
	BRA.S	.NO_UP_INC
.STILL_ACRU
	SUB.L	Y_ACC(PC),D1
.NO_UP_INC:
	BTST	#0,D7				DOWN?
	BEQ.S	.NO_DOWN_INC
	CMP.L	#$90000,D1
	BLE.S	.STILL_ACRD
	ADD.L	Y_DAMPING(PC),D1		MAINTAIN MAX VELOCITY
	BRA.S	.NO_DOWN_INC
.STILL_ACRD:
	ADD.L	Y_ACC(PC),D1
.NO_DOWN_INC:
	ADD.L	D1,D4				ADD Y VELOCITIES
	CMP.L	#$1E0000,D4			AND CHECK FOR BOUNDARIES
	BLT	.AT_BOTTOM
	CMP.L	#$F00000,D4
	BGT	.AT_TOP
.END:
	MOVEM.L	D0-D6,CURRENT_X_VEL	REPLACE ALL THE CHANGED VARIABLES

	MOVE.L	CURRENT_SHIP_X(PC),D0
	LSR.L	#8,D0
	LSR.L	#2,D0
	MOVE.W	D0,SHIP_X_REAL
	
	TST.B	MOVE_OVERRIDE
	BNE.S	.NO_FIRE
	TST.W	MISSILE_COUNT		limit fire rate
	BEQ.S	.DO_TEST		
	SUBQ.W	#1,MISSILE_COUNT
.NO_FIRE:
	RTS
.DO_TEST:
	TST.W	AUTOFIRE
	BNE.S	.CHECK_FOR_PRESS
	TST.W	.BUTTON_IND		check that every time
	BEQ.S	.CHECK_FOR_PRESS	the player presses the button
	BTST	#7,D7			he depresses it again to fire
	BNE	.NO_BUTTON		next missile!
	NOT.W	.BUTTON_IND
	BRA	.NO_BUTTON
.CHECK_FOR_PRESS:
	BTST	#7,D7			check for button press
	BEQ	.NO_BUTTON
	NOT.W	.BUTTON_IND
	TST.W	AUTOFIRE
	BEQ.S	.NO_AUTO
	MOVE.W	#3,MISSILE_COUNT
	BRA.S	.PAST_AUTO_CHECK
.NO_AUTO:
	MOVE.W	#1,MISSILE_COUNT
.PAST_AUTO_CHECK:
	MOVEQ	#10,D7
	LSR.L	D7,D5
   	SWAP	D4
	SUB.W	#14,D4			center of ship y
	LEA	THINGS_TO_DO_LIST(PC),A1
	BSR.S	.FIND_SLOT_LOOP
	MOVE.W	#1,(A1)+
	MOVE.L	(A1)+,A2		get slot data pos
	SF	30(A2)			not dead
	SF	31(A2)			indestructible
	MOVE.L	#MISSILE1_ROUTINE,(A2)+	tell it what routine to use
	MOVE.L	#MISSILE_LIST,(A2)+	object list pointer	
	SUB.W	#32,D5
	MOVE.W	D5,(A2)+		x
	MOVE.W	D4,(A2)+		y
	MOVE.W	#-32,(A2)+		z(0) = start from ship
	BSR.S	.FIND_SLOT_LOOP
	MOVE.W	#1,(A1)+
	MOVE.L	(A1)+,A2		get slot data pos
	SF	30(A2)			not dead
	SF	31(A2)			indestructible
	MOVE.L	#MISSILE1_ROUTINE,(A2)+	tell it what routine to use
	MOVE.L	#MISSILE_LIST,(A2)+	object list pointer
	ADD.W	#52,D5
	MOVE.W	D5,(A2)+		x
	MOVE.W	D4,(A2)+		y
	MOVE.W	#-32,(A2)+		z(0) = start from ship!
	RTS

.FIND_SLOT_LOOP:
	TST.W	(A1)
	BMI.S	.NO_BUTTON
	ADDQ.L	#6,A1
	BRA.S	.FIND_SLOT_LOOP	
.NO_BUTTON:
	RTS

.AT_BOTTOM:
	MOVEQ	#0,D1
	MOVE.L	#$1E0000,D4
	BRA	.END
.AT_TOP:
	MOVEQ	#0,D1
	MOVE.L	#$F00000,D4
	BRA	.END

.BUTTON_IND:	DC.W	0


*****************************************************************************
* THIS IS THE QUIT ROUTINE
*****************************************************************************

QUIT
	MOVE.W 	#$2700,SR		TURN OFF INTS
	BSR 	HBLOFF			RESET VALUES
	LEA 	$FFFF8800.W,A1		BLANK SOUNDCHIP
	MOVE.L 	#$8080000,(A1)
	MOVE.L 	#$9090000,(A1)
	MOVE.L 	#$A0A0000,(A1)
	MOVE.W 	#$2300,SR		TURN BACK ON INTS
	MOVEQ	#1,D7
	LEA	KEYBOARD_OFF(PC),A0
	BSR 	IKBD	
	MOVEM.L	OLD_PALETTE,D0-D7	PUT BACK OLD PALETTE
	MOVEM.L	D0-D7,$FFFF8240.W
	MOVE.W	#1,-(SP)		SWITCH BACK TO MEDIUM RES
	MOVE.L	#-1,-(SP)
	MOVE.L	#-1,-(SP)
	MOVE.W	#5,-(SP)
	TRAP	#14
	ADD.L	#12,SP
	MOVE.L	OLDSSP,-(A7)		RESTORE STACK
	MOVE.W	#$20,-(SP)		AND PUT BACK INTO USER MODE
	TRAP	#1
	ADDQ.L	#6,SP

	ILLEGAL

******************************************************************************
* ROUTINE FOR SETTING UP OF GENERAL INTERRUPTS
******************************************************************************

HBL_ON
	MOVE.L 	$FFFF8200.W,OLD_PHYS
	MOVE.L 	$120.W,OLD_TB		SAVE INTERRUPTS
	MOVE.L 	$70.W,OLD_VBL
	MOVE.L 	$118.W,OLD_KEY
	MOVE.L	$68.W,OLDHBL
	MOVE.L	$114.W,OLD_TIMER_C
	MOVE.L	$20.W,OLD_PRIV
	MOVE.B 	$FFFFFA07.W,OLD_07
	MOVE.B 	$FFFFFA09.W,OLD_09
	MOVE.B 	$FFFFFA0F.W,OLD_0F
	MOVE.B 	$FFFFFA13.W,OLD_13
	MOVE.B 	$FFFFFA1B.W,OLD_1B
	MOVE.B	$FFFFFA17.W,OLD_17
	MOVE.B	$FFFFFA1D.W,OLD_1D
	MOVE.B	$FFFFFA1F.W,OLD_1F
	MOVE.B	$FFFFFA23.W,OLD_23
	MOVE.B	$FFFFFA15.W,OLD_15
	MOVE.B	$FFFFFA11.W,OLD_11
	MOVE.B	$FFFFFA0D.W,OLD_0D
	MOVE.L	USP,A0
	MOVE.L	A0,OLD_USP
	MOVE.L	$8.W,OLD_8		SAVE ERROR VECTORS
	MOVE.L	$C.W,OLD_C
	MOVE.L	$10.W,OLD_10
	MOVE.L	$20.W,OLD_20
	LEA	SERIOUS_ERROR(PC),A0	PUT IN OUR OWN ERROR HANDLER
	MOVE.L	A0,$8.W
	MOVE.L	A0,$C.W
	MOVE.L	A0,$10.W
	MOVE.L	A0,$20.W
	AND.B 	#$DF,$FFFFFA09.W	THEN SET UP OURS
	AND.B 	#$FE,$FFFFFA07.W
	MOVE.L 	#NULL_B,$120.W		FIRST TIMER B
	MOVE.L 	#NULL_VBL,$70.W		FIRST VBL
	BCLR	#3,$FFFFFA17.W
	OR.B 	#1,$FFFFFA07.W
	OR.B 	#1,$FFFFFA13.W
	BCLR 	#6,$FFFFFA09.W		PUT IN OUR NEW 
	MOVE.L 	#KEY_VECTOR,$118.W	KEY VECTOR
	BSET 	#6,$FFFFFA09.W
	MOVE.W	#$2300,SR
	RTS

**************************************************************************
* RESTORE ALL THE PREVIOUSLY STORED INTERRUPTS
**************************************************************************

HBLOFF	MOVE.W 	SR,-(SP)		TAKE OUT ALL OF OUR INTS
	MOVE.W 	#$2700,SR
	MOVE.B 	OLD_07(PC),$FFFFFA07.W
	MOVE.B 	OLD_09(PC),$FFFFFA09.W
	MOVE.B 	OLD_0F(PC),$FFFFFA0F.W
	MOVE.B 	OLD_13(PC),$FFFFFA13.W
	MOVE.B 	OLD_1B(PC),$FFFFFA1B.W
	MOVE.B	OLD_17(PC),$FFFFFA17.W
	MOVE.B	OLD_1D(PC),$FFFFFA1D.W
	MOVE.B	OLD_1F(PC),$FFFFFA1F.W
	MOVE.B	OLD_1D(PC),$FFFFFA1D.W
	MOVE.B	OLD_15(PC),$FFFFFA15.W
	MOVE.B	OLD_11(PC),$FFFFFA11.W
	MOVE.L	OLD_USP(PC),A0
	MOVE.L	A0,USP
	MOVE.B	#180,$FFFFFA23.W
	MOVE.L 	OLD_TB(PC),$120.W
	MOVE.L 	OLD_VBL(PC),$70.W
	MOVE.L 	OLD_KEY(PC),$118.W
	MOVE.L	OLDHBL(PC),$68.W
	MOVE.L	OLD_TIMER_C(PC),$114.W
	MOVE.L	OLD_PRIV(PC),$20.W
	MOVE.L 	OLD_PHYS(PC),$FFFF8200.W
	MOVE.L	OLD_8(PC),$8.W
	MOVE.L	OLD_C(PC),$C.W
	MOVE.L	OLD_10(PC),$10.W
	MOVE.L	OLD_20(PC),$20.W
	MOVE.W 	(SP)+,SR
	RTS

OLD_8:		DC.L	0
OLD_C:		DC.L	0
OLD_10:		DC.L	0
OLD_20:		DC.L	0
OLDSSP		DC.L	0		*OLDSTACK
OLD_PALETTE	DS.L	8		*OLD ST PALETTE
OLD_TB		DC.L	0
OLD_VBL		DC.L	0
OLD_KEY		DC.L	0
OLD_PHYS	DC.L	0
OLDHBL		DC.L	0
OLD_TIMER_C:	DC.L	0
OLD_PRIV:	DC.L	0
OLD_USP:	DC.L	0
OLD_07		DC.B	0
OLD_09		DC.B	0
OLD_0F		DC.B	0
OLD_13		DC.B	0
OLD_17		DC.B	0
OLD_1B		DC.B	0
OLD_1D		DC.B	0
OLD_1F		DC.B	0
OLD_23		DC.B	0
OLD_15		DC.B	0
OLD_0D		DC.B	0
OLD_11		DC.B	0
VBLIND		DC.B	0	
		EVEN

*****************************************************************************
* THIS IS WHERE ALL THE INTERRUPTS ARE KEPT!!
*****************************************************************************

KEY_VECTOR:				*THE NEW KEY VECTOR
	MOVE.L	A0,-(A7)
	MOVE.L 	D2,-(SP)
	LEA	KEY_VARIABLES(PC),A0
AND_AG:	MOVE.B 	$FFFFFC00.W,D2		
	BTST 	#7,D2			ANY CHARACTER WAITING?
	BEQ.S	VECTOREND		NO THEN END
	MOVEQ	#0,D2
	MOVE.B 	$FFFFFC02.W,D2		READ CHARACTER INTO  'KBUFF'
	TST.W	(A0)
	BNE.S	JOY_PACKAGE1		GET THE JOYSTICK PACK FOR PORT 0
	TST.W	2(A0)
	BNE.S	JOY_PACKAGE2		GET THE JOYSTICK PACK FOR PORT 1
	CMP.B	#$FE,D2
	BEQ.S	JOY1
	CMP.B	#$FF,D2			IS IT A JOYSTICK PACKAGE
	BNE.S	NORMAL_KEY		NOPE NORMAL KEY!
	ST	(A0)
	BRA.S	AND_AG
	
NORMAL_KEY:
	TST.B	D2			KEY PRESSED
	BPL.S	.SET_KEY
.CLR_KEY:
	BCLR	#7,D2			ELSE KEY DEPRESSED
	SF	10(A0,D2.W)
	BRA.S	.1
.SET_KEY:
	ST	10(A0,D2.W)
	MOVE.B	D2,8(A0)
.1	BTST	#4,$FFFFFA01.W
	BEQ.S	AND_AG
VECTOREND:
	MOVE.L 	(SP)+,D2
	MOVE.L	(SP)+,A0
	RTE

JOY_PACKAGE1:
	MOVE.B 	D2,4(A0)
	CLR.W	(A0)
	BRA.S	AND_AG

JOY1:	ST	2(A0)
	BRA.S	AND_AG

JOY_PACKAGE2:
	MOVE.B 	D2,6(A0)
	CLR.W	2(A0)
	BRA.S	AND_AG
	
*********************
KEY_VARIABLES:
NEXT_JOY1:	DC.W	0
NEXT_JOY2:	DC.W	0
JBUFF0:		DC.W	0
JBUFF1:		DC.W	0
KBUFF:		DC.W	0
*********************

KEY_BUFFER	DS.B	128

***************************************************
* IN THE EVENT OF A SERIOUS INTERRUPT CRASH!!     *
***************************************************

SERIOUS_ERROR:
	MOVE.W	#$2700,SR		WELL COMPLEX ERROR HANDLER
	MOVE.L	#200000,D0
.LOOP	ADDQ.W	#2,$FFFF8240.W
	SUBQ.L	#1,D0
	BNE.S	.LOOP
	BRA	QUIT

*************************************************
* THE VBL ROUTINE(S)                            *
*************************************************

NULL_VBL:
	MOVE.B	#0,$FFFF8260.W			LOW RES
	MOVEM.L	D0-A6,-(A7)

	TST.B	FADE_IN				DO WE NEED FADE IN?
	BEQ.S	.NO_FADE_IN			NOPE!
	CLR.W	CHANGE
	LEA	TEXT_PALETTE_BACK(PC),A0	FIRST FADE PALETTE
	LEA	TEXT_PALETTE(PC),A1

	MOVEQ	#15,D7
	BSR	SINGLE_PALETTE_FADE_IN

	TST.W	CHANGE
	BNE.S	.NO_FADE_OUT
	SF	FADE_IN
	BRA.S	.NO_FADE_OUT

.NO_FADE_IN:
	TST.B	FADE_OUT			SAME BUT FOR FADE OUT
	BEQ.S	.NO_FADE_OUT
	CLR.W	CHANGE

	LEA	TEXT_PALETTE(PC),A1
	MOVEQ	#15,D7
	BSR	SINGLE_PALETTE_FADE_OUT

	TST.W	CHANGE
	BNE.S	.NO_FADE_OUT
	SF	FADE_OUT
.NO_FADE_OUT:

	MOVEM.L	TEXT_PALETTE(PC),D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W
	MOVE.L	#SCREEN1,D0
	LSR.W	#8,D0
	MOVE.L	D0,$FFFF8200.W
	MOVEM.L	(A7)+,D0-A6
	TST.B	KEY_BUFFER+$1
	BNE	QUIT
	RTE

TEXT_PALETTE_BACK:	DC.W	$000,$000,$000,$000,$000,$000,$000,$000
			DC.W	$000,$000,$000,$000,$000,$000,$000,$777
TEXT_PALETTE:		DC.W	$000,$000,$000,$000,$000,$000,$000,$000
			DC.W	$000,$000,$000,$000,$000,$000,$000,$000

VBL_1:
	MOVE.B	#0,$FFFF8260.W			LOW RES
	MOVEM.L	D0-A6,-(A7)
	CLR.B	$FFFFFA1B.W			START TIMER B
	MOVE.B	#10,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
R_COLA:	MOVE.B	#1,$FFFFFA21.W
	MOVE.L	#FIRST_TIMER_B,$120.W		POINT IT TO FIRST INTERUPT
	MOVEM.L	BACK_PANEL_PALETTE(PC),D0-D7		SET PALETTE
	MOVEM.L	D0-D7,$FFFF8240.W

	IFNE	FRAME_COUNTER		
*********** FRAME RATE BIT ************	
	LEA	FRAME_VARS(PC),A0
	SUBQ.W	#1,(A0)
	BNE.S	.NO_NEW_STORE
	MOVE.W	2(A0),4(A0)
	CLR.W	2(A0)
	MOVE.W	#50,(A0)
.NO_NEW_STORE:
	MOVEQ	#0,D0
	MOVE.W	4(A0),D0
	DIVU	#10,D0
	MOVE.W	D0,D1
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D1,D0
	
	MOVE.L	LOGBASE+4(PC),A2
	LEA	12*160(A2),A2
	LEA	COUNT_FONT(PC,D0.W),A1
	MOVE.B	(A1)+,2(A2)	
	MOVE.B	(A1)+,162(A2)	
	MOVE.B	(A1)+,322(A2)	
	MOVE.B	(A1)+,482(A2)	
	MOVE.B	(A1)+,642(A2)	
	SWAP	D0
	MOVE.W	D0,D1
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D1,D0
	LEA	COUNT_FONT(PC,D0.W),A1
	MOVE.B	(A1)+,3(A2)	
	MOVE.B	(A1)+,163(A2)	
	MOVE.B	(A1)+,323(A2)	
	MOVE.B	(A1)+,483(A2)	
	MOVE.B	(A1)+,643(A2)	
	ENDC

	MOVEM.L	(A7)+,D0-A6
	ADDQ.B	#1,VBLIND			TELL PROG WE'VE BEEN HERE
	TST.B	KEY_BUFFER+$1			CHECK FOR EXIT
	BNE	QUIT
	RTE

	IFNE	FRAME_COUNTER
FRAME_VARS:
	DC.W	50,0,0

COUNT_FONT:
	DC.B	%01111000
	DC.B	%10000100
	DC.B	%10000100
	DC.B	%10000100
	DC.B	%01111000

	DC.B	%00110000
	DC.B	%01010000
	DC.B	%00010000
	DC.B	%00010000
	DC.B	%01111000

	DC.B	%01111000
	DC.B	%10000100
	DC.B	%00111000
	DC.B	%01000000
	DC.B	%11111100

	DC.B	%11111000
	DC.B	%00000100
	DC.B	%01111000
	DC.B	%00000100
	DC.B	%11111000

	DC.B	%10000000
	DC.B	%10010000
	DC.B	%11111000
	DC.B	%00010000
	DC.B	%00010000

	DC.B	%11111000
	DC.B	%10000000
	DC.B	%11111000
	DC.B	%00001000
	DC.B	%11111000

	DC.B	%11111000
	DC.B	%10000000
	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000

	DC.B	%11111000
	DC.B	%00001000
	DC.B	%00010000
	DC.B	%00100000
	DC.B	%00100000

	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000

	DC.B	%11111000
	DC.B	%10001000
	DC.B	%11111000
	DC.B	%00001000
	DC.B	%11111000
	ENDC

FIRST_TIMER_B:
	MOVE.L	A0,-(A7)
R_COLB:	MOVE.B	#1,$FFFFFA21.W
	MOVE.L	#START_RASTER,$120.W		point it to first interrupt
	LEA	BACK_PALETTE(PC),A0		set palette
	MOVE.L	(A0)+,$FFFF8240.W
	MOVE.L	(A0)+,$FFFF8244.W
	MOVE.L	(A0)+,$FFFF8248.W
	MOVE.L	(A0)+,$FFFF824C.W
	MOVE.L	(A0)+,$FFFF8250.W
	MOVE.L	(A0)+,$FFFF8254.W
	MOVE.L	(A0)+,$FFFF8258.W
	MOVE.L	(A0)+,$FFFF825C.W
	MOVE.L	(A7)+,A0
	RTE

BOTTOM_PANEL_RASTER:
	MOVE.L	A0,-(A7)
	LEA	BACK_PANEL_PALETTE(PC),A0
	MOVE.L	(A0)+,$FFFF8240.W
	MOVE.L	(A0)+,$FFFF8244.W
	MOVE.L	(A0)+,$FFFF8248.W
	MOVE.L	(A0)+,$FFFF824C.W
	MOVE.L	(A0)+,$FFFF8250.W
	MOVE.W	(A0)+,$FFFF8254.W
	LEA	10(A0),A0
	MOVE.W	(A0)+,$FFFF8256.W
	MOVE.L	(A0)+,$FFFF8258.W
	MOVE.L	(A0)+,$FFFF825C.W
	MOVE.L	(A7)+,A0
	MOVE.L	#BOTTOM_PANEL_RASTER2,$120.W
	MOVE.B	#100,$FFFFFA21.W
	RTE
BOTTOM_PANEL_RASTER2:
	MOVE.W	BACK_PANEL_PALETTE+22(PC),$FFFF8256.W
	MOVE.L	BACK_PANEL_PALETTE+24(PC),$FFFF8258.W
	MOVE.L	BACK_PANEL_PALETTE+28(PC),$FFFF825C.W
	RTE

************************************************
* ROUTINE TO WRITE OPTIMAL RASTER ROUTINES     *
************************************************

SET_UP_RASTERS:
	LEA	BACK_PALETTE(PC),A0
	MOVEQ	#0,D6
	MOVEQ	#7,D7
.LOOP_PAL:
	MOVE.L	D6,(A0)+
	DBF	D7,.LOOP_PAL

	LEA	START_RASTER(PC),A0
	LEA	RASTERS(PC),A1
	LEA	BACK_RASTERS(PC),A4
	LEA	RASTER_COUNT(PC),A5
	CLR.W	(A5)
	MOVEQ	#Y_MIDDLE-15,D6		CURRENT RASTER COUNT
	MOVEQ	#59,D7			NUMBER OF LINES TO MONITOR
	MOVEQ	#0,D5			CURRENT	COLOR
.LOOP:	
	MOVE.W	(A1)+,D4
	CMP.W	D4,D5
	BEQ.S	.SAME_COLOR
	MOVE.L	ALTERS(PC),A2
	MOVE.W	D4,D5
	MOVE.W	D6,(A2)			PUT IN NUMBER OF LINES
	MOVE.L	ALTERS+4(PC),ALTERS	
	MOVEQ	#1,D6			RESET RASTER COUNT
	MOVE.W	#$31FC,(A0)+
	MOVE.W	#0,(A0)+
	MOVE.W	D5,(A4)+		SAVE RASTER FOR FADING
	ADDQ.W	#1,(A5)			ADD 1 TO RASTER COUNT
	MOVE.W	#$8242,(A0)+	
	MOVE.L	#$11FC0000,(A0)+
	LEA	-2(A0),A2
	MOVE.L	A2,ALTERS+4
	MOVE.W	#$FA21,(A0)+
	MOVE.W	#$31FC,(A0)+
	LEA	6(A0),A3
	MOVE.W	A3,(A0)+
	MOVE.W	#$122,(A0)+
	MOVE.W	#$4E73,(A0)+
	DBF	D7,.LOOP
	BRA.S	.FINISH_IT
	
.SAME_COLOR:
	ADDQ.W	#1,D6			add 1 to raster count
	DBF	D7,.LOOP
.FINISH_IT:
	MOVE.L	ALTERS(PC),A2
	SUB.W	#10+SCORE_PANEL_Y,D6	size of score panel
	MOVE.W	D6,(A2)			put in number of lines
	MOVE.L	ALTERS+4(PC),A2
	MOVE.W	#63,(A2)		height of water bit
	MOVE.W	#$31FC,(A0)+
	MOVE.W	#0,(A0)+
	MOVE.W	PALETTE+2(PC),(A4)+
	MOVE.W	#$8242,(A0)+	
	MOVE.W	#$21FC,(A0)+
	MOVE.L	#BOTTOM_PANEL_RASTER,(A0)+
	MOVE.W	#$120,(A0)+
	MOVE.L	#$11FC0012,(A0)+
	MOVE.W	#$FA21,(A0)+
	MOVE.W	#$4E73,(A0)+
	MOVE.W	RASTERS(PC),PALETTE+2
	RTS

ALTERS:	DC.L	R_COLA+2,R_COLB+2

*********************************
*      TIMER B INTERRUPTS       *
*********************************

START_RASTER:
	DS.B	(20*60)+8

NULL_B:	RTE

**********************************************
* SHIT BORING ROUTINES (CLS ETC)             *
**********************************************

CLEAR_SCREENS:
	LEA	SCREEN1,A0
	LEA	MEG+$80000,A1
.LOOP	CLR.L	(A0)+
	CMP.L	A1,A0
	BLT.S	.LOOP
	RTS

ADD_PLANE1_AND_PANEL:
	LEA	SCREEN1+(CONTROL_PANEL_Y*160),A0
	LEA	SCREEN2+(CONTROL_PANEL_Y*160),A1
	LEA	SCREEN3+(CONTROL_PANEL_Y*160),A2
	LEA	PANEL_GFX,A3
	MOVE.W	#5120/4-1,D7
.LOOPA:	MOVE.L	(A3)+,D0
	MOVE.L	D0,(A0)+
	MOVE.L	D0,(A1)+
	MOVE.L	D0,(A2)+
	DBF	D7,.LOOPA

	LEA	SCREEN1+(SCORE_PANEL_Y*160),A0
	LEA	SCREEN2+(SCORE_PANEL_Y*160),A1
	LEA	SCREEN3+(SCORE_PANEL_Y*160),A2
	LEA	SCORE_PANEL_GX,A3
	MOVE.W	#(10*160)/4-1,D7
.LOOPC:	MOVE.L	(A3)+,D0
	MOVE.L	D0,(A0)+
	MOVE.L	D0,(A1)+
	MOVE.L	D0,(A2)+
	DBF	D7,.LOOPC

	LEA	SCREEN1+((Y_MIDDLE-45)*160),A0
	LEA	SCREEN2+((Y_MIDDLE-45)*160),A1
	LEA	SCREEN3+((Y_MIDDLE-45)*160),A2
	MOVE.L	#$FFFF0000,D0
	MOVEQ	#0,D1
	MOVE.W	#739,D2
.LOOPB:
	MOVE.L	D0,(A0)+
	MOVE.L	D1,(A0)+
	MOVE.L	D0,(A1)+
	MOVE.L	D1,(A1)+
	MOVE.L	D0,(A2)+
	MOVE.L	D1,(A2)+
	DBF	D2,.LOOPB

	MOVE.W	LIVES(PC),D0		life counter
	
	MOVEQ	#0,D2
	MOVEQ	#10,D1
.LOOP5	CMP.L	D1,D0
	BLT.S	.DRAWL1
	ADDQ.W	#1,D2
	SUB.L	D1,D0
	BRA.S	.LOOP5			10's in d2, 1's in d0
.DRAWL1:
	LEA	SCREEN1+((SCORE_PANEL_Y+2)*160)+120,A0
	BSR	DRAW_BYTE2
	LEA	SCREEN2+((SCORE_PANEL_Y+2)*160)+120,A0
	BSR	DRAW_BYTE2B
	LEA	SCREEN3+((SCORE_PANEL_Y+2)*160)+120,A0
	BSR	DRAW_BYTE2B
	MOVE.L	D0,D2
	LEA	SCREEN1+((SCORE_PANEL_Y+2)*160)+128,A0
	BSR	DRAW_BYTE1
	LEA	SCREEN2+((SCORE_PANEL_Y+2)*160)+128,A0
	BSR	DRAW_BYTE1B
	LEA	SCREEN3+((SCORE_PANEL_Y+2)*160)+128,A0
	BSR	DRAW_BYTE1B

	RTS

**************************************************************************
* WRITE DATA TO KEYBOARD PROCESSOR. LIST IN A0
**************************************************************************

KEYBOARD_ON:	DC.B	$12,$14
KEYBOARD_OFF:	DC.B	$14,$8

IKBD:
	LEA 	$FFFFFC00.W,A1		WRITE TO THE KEYBOARD
IKLOOP	MOVE.B 	(A1),D1			PROCESSOR
	BTST 	#1,D1			READY TO RECIEVE DATA?
	BEQ.S 	IKLOOP
	MOVE.B 	(A0)+,2(A1)		SEND DATA
	DBF	D7,IKLOOP
	RTS

****************************************************************************
* THE VSYNC ROUTINE
****************************************************************************

VSYNC
	CMP.B	#VBL_COUNT,VBLIND
	BLT.S	VSYNC
	CLR.B	VBLIND
	RTS

**************************************************
* THE ROUTINES FOR FADING IN AND OUT THE FRACTAL *
**************************************************

FADE_IN:	DC.B	0
FADE_OUT:	DC.B	0
CHANGE:		DC.W	0

THE_FADE_ROUTINES:
	TST.B	FADE_IN				DO WE NEED FADE IN?
	BEQ	.NO_FADE_IN			NOPE!
	CLR.W	CHANGE

	LEA	PALETTE(PC),A0			FIRST FADE PALETTE
	LEA	BACK_PALETTE(PC),A1
	MOVEQ	#15,D7
	BSR	SINGLE_PALETTE_FADE_IN

	LEA	PANEL_PALETTE(PC),A0		FIRST FADE PALETTE
	LEA	BACK_PANEL_PALETTE(PC),A1
	MOVEQ	#15+5,D7
	BSR	SINGLE_PALETTE_FADE_IN

	LEA	BACK_RASTERS(PC),A0
	LEA	START_RASTER+2(PC),A1		THEN FADE RASTERS
	MOVE.W	RASTER_COUNT(PC),D7
.FADE_IN_LOOP2:
	MOVE.W	(A0)+,D0
	MOVE.W	(A1),D1
	CMP.W	D0,D1
	BEQ.S	.FADED2
	ST	CHANGE
	MOVE.W	D0,D2
	AND.W	#$700,D2
	MOVE.W	D1,D3
	AND.W	#$700,D3
	CMP.W	D2,D3
	BEQ.S	.R12
	ADD.W	#$100,D1
.R12	MOVE.W	D0,D2
	AND.W	#$70,D2
	MOVE.W	D1,D3
	AND.W	#$70,D3
	CMP.W	D2,D3
	BEQ.S	.R22
	ADD.W	#$10,D1
.R22	MOVE.W	D0,D2
	AND.W	#$7,D2
	MOVE.W	D1,D3
	AND.W	#$7,D3
	CMP.W	D2,D3
	BEQ.S	.FADED2
	ADDQ.W	#$1,D1
.FADED2:
	MOVE.W	D1,(A1)
	LEA	20(A1),A1
	DBF	D7,.FADE_IN_LOOP2

	TST.W	CHANGE
	BNE.S	.1
	SF	FADE_IN
	MOVE.W	#$4E71,FADE_INSERT
	MOVE.L	#$4E714E71,FADE_INSERT+2
.1	RTS

.NO_FADE_IN:
	TST.B	FADE_OUT			SAME BUT FOR FADE OUT
	BEQ.S	.NO_FADE_OUT
	CLR.W	CHANGE

	LEA	BACK_PALETTE(PC),A1
	MOVEQ	#15,D7
	BSR	SINGLE_PALETTE_FADE_OUT

	LEA	BACK_PANEL_PALETTE(PC),A1
	MOVEQ	#15+5,D7
	BSR	SINGLE_PALETTE_FADE_OUT

	LEA	START_RASTER+2(PC),A1
	MOVE.W	RASTER_COUNT(PC),D7
.FADE_OUT_LOOP2:
	MOVE.W	(A1),D1
	BEQ.S	.FADED_OUT2
	ST	CHANGE
	MOVE.W	D1,D2
	AND.W	#$700,D2
	BEQ.S	.R42
	SUB.W	#$100,D1
.R42	MOVE.W	D1,D2
	AND.W	#$70,D2
	BEQ.S	.R52
	SUB.W	#$10,D1
.R52	MOVE.W	D1,D2
	AND.W	#$7,D2
	BEQ.S	.FADED_OUT2
	SUBQ.W	#$1,D1
.FADED_OUT2:
	MOVE.W	D1,(A1)
	LEA	20(A1),A1
	DBF	D7,.FADE_OUT_LOOP2

	TST.W	CHANGE
	BNE.S	.NO_FADE_OUT
	SF	FADE_OUT
	MOVE.W	#$4E71,FADE_INSERT
	MOVE.L	#$4E714E71,FADE_INSERT+2
.NO_FADE_OUT:
	RTS

SINGLE_PALETTE_FADE_IN:
.FADE_IN_LOOP:
	MOVE.W	(A0)+,D0
	MOVE.W	(A1)+,D1
	CMP.W	D0,D1
	BEQ.S	.FADED
	ST	CHANGE
	MOVE.W	D0,D2
	AND.W	#$700,D2
	MOVE.W	D1,D3
	AND.W	#$700,D3
	CMP.W	D2,D3
	BEQ.S	.R1
	ADD.W	#$100,D1
.R1	MOVE.W	D0,D2
	AND.W	#$70,D2
	MOVE.W	D1,D3
	AND.W	#$70,D3
	CMP.W	D2,D3
	BEQ.S	.R2
	ADD.W	#$10,D1
.R2	MOVE.W	D0,D2
	AND.W	#$7,D2
	MOVE.W	D1,D3
	AND.W	#$7,D3
	CMP.W	D2,D3
	BEQ.S	.FADED
	ADDQ.W	#$1,D1
.FADED:	MOVE.W	D1,-2(A1)
	DBF	D7,.FADE_IN_LOOP
	RTS

SINGLE_PALETTE_FADE_OUT:
.FADE_OUT_LOOP:
	MOVE.W	(A1),D1
	BEQ.S	.FADED_OUT
	ST	CHANGE
	MOVE.W	D1,D2
	AND.W	#$700,D2
	BEQ.S	.R4
	SUB.W	#$100,D1
.R4	MOVE.W	D1,D2
	AND.W	#$70,D2
	BEQ.S	.R5
	SUB.W	#$10,D1
.R5	MOVE.W	D1,D2
	AND.W	#$7,D2
	BEQ.S	.FADED_OUT
	SUBQ.W	#$1,D1
.FADED_OUT:
	MOVE.W	D1,(A1)+
	DBF	D7,.FADE_OUT_LOOP
	RTS

**********************************************
* THE INITIALISATION ROUTINES                *
**********************************************

PREPARE_PROJ_DIVU:
	LEA	PROJ_DIVU_TAB,A0
	MOVE.L	#(16777216*3)/2,D1
	MOVE.L	#16384,D2
	MOVE.L	#16383,D0
.LOOP
	MOVE.L	D2,D3
	SUB.L	D0,D3
	ADD.L	D3,D3
	MOVE.L	D1,D4
	DIVU	D3,D4
	MOVE.W	D4,(A0)+
	SUBQ.W	#1,D0
	CMP.W	#15184,D0
	BNE.S	.LOOP
	RTS

************************************************
* MAKES UP A MULTIPLIER TABLE                  *
************************************************

PREPARE_GRID_MULT:
	LEA	GRID_MULT_TABLE_END,A0
	MOVE.W	#GRID_SIZE*16,D0
.LOOP:
	MOVE.W	D0,D1
	MULU	#(GRID_SIZE+1)*2,D1
	MOVE.L	D1,-(A0)
	DBF	D0,.LOOP
	RTS

**********************************************
* RANDOM NUMBER GENERATOR                    *
**********************************************

RANDOM:
	MOVEM.W	RANDOM_NUMBER(PC),D0-D1
	ROR.W	#1,D0
	ADDQ.W	#7,D0
	EOR.W	D1,D0
	EXG	D0,D1
	MOVEM.W	D0-D1,RANDOM_NUMBER
	RTS

**********************************************************
* HERE FOLLOW ALL THE ROUTINES PERTAINING TO THE FRACTAL *
* CALCULATION.					         *
**********************************************************

CLEAN_ARRAY_A:
	LEA	MAP_ARRAY,A0		*THIS FILLS THE ENTIRE MAP
	MOVE.W	LAND_LEVEL(PC),D0	*TO THE INITIAL LAND LEVEL
.LOOP:	MOVE.W	D0,(A0)+
	CMP.L	#MAP_ARRAY_END,A0
	BNE.S	.LOOP
	RTS

CLEAN_ARRAY_B
	CMP.W	#2,CREATION_STYLE	
	BEQ.S	.NO_MORE_NEEDED

	MOVE.W	WATER_LEVEL,D1
	SUB.W	#10,D1

	MOVEQ	#GRID_SIZE,D0			THIS ENSURES THAT THE TOP AND 
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY+((GRID_SIZE*16)*((GRID_SIZE+1)*2))),A3
.LOOP1:	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A3)+
	DBF	D0,.LOOP1

	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS
	MOVE.W	LAND_LEVEL(PC),D1
	ADD.L	#1500,D1
.MISS:
	MOVE.W	#GRID_SIZE*16,D0		THIS MAKES LEFT AND RIGHT EDGE
	LEA	MAP_ARRAY,A1			ABOVE SEA LEVEL
	LEA	MAP_ARRAY+(GRID_SIZE*2),A2
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS1
	LEA	MAP_ARRAY+GRID_SIZE,A3		AND PUTS A VALEEY IN IF NEEDED
	MOVE.W	RIVER_HEIGHT(PC),D2
.MISS1:
.LOOP2:
	MOVE.W	D1,(A1)			
	MOVE.W	D1,(A2)
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS2
	MOVE.W	D2,(A3)
	LEA	(GRID_SIZE+1)*2(A3),A3
.MISS2
	LEA	(GRID_SIZE+1)*2(A1),A1
	LEA	(GRID_SIZE+1)*2(A2),A2
	DBF	D0,.LOOP2
.NO_MORE_NEEDED:
	RTS

CLEAN_COLOR_ARRAY_THINGY:
	LEA	COLOR_ARRAY,A0		*THIS FILLS THE ENTIRE MAP
	MOVE.W	LAND_LEVEL(PC),D0	*TO THE INITIAL LAND LEVEL
.LOOP:	MOVE.W	D0,(A0)+
	CMP.L	#COLOR_ARRAY+((GRID_SIZE+1)*(GRID_SIZE+1)*2),A0
	BNE.S	.LOOP

	CMP.W	#2,CREATION_STYLE	
	BEQ.S	.NO_MORE_NEEDED

	MOVEQ	#GRID_SIZE,D0			THIS ENSURES THAT THE TOP AND 
	MOVE.W	WATER_LEVEL(PC),D1		BOTTOM EDGES ARE AT SEA LEVEL
	LEA	COLOR_ARRAY,A0
	LEA	COLOR_ARRAY+(GRID_SIZE*((GRID_SIZE+1)*2))),A3
.LOOP1:	MOVE.W	D1,(A0)+
	MOVE.W	D1,(A3)+
	DBF	D0,.LOOP1

	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS
	MOVE.W	LAND_LEVEL(PC),D1
	ADD.L	#1500,D1
.MISS:
	MOVEQ	#GRID_SIZE,D0			THIS MAKES LEFT AND RIGHT EDGE
	LEA	COLOR_ARRAY,A1			ABOVE SEA LEVEL
	LEA	COLOR_ARRAY+(GRID_SIZE*2),A2
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS1
	LEA	COLOR_ARRAY+GRID_SIZE,A3		AND PUTS A VALEEY IN IF NEEDED
	MOVE.W	RIVER_HEIGHT(PC),D2
.MISS1:
.LOOP2:
	MOVE.W	D1,(A1)			
	MOVE.W	D1,(A2)
	CMP.W	#1,CREATION_STYLE
	BNE.S	.MISS2
	MOVE.W	D2,(A3)
	LEA	(GRID_SIZE+1)*2(A3),A3
.MISS2
	LEA	(GRID_SIZE+1)*2(A1),A1
	LEA	(GRID_SIZE+1)*2(A2),A2
	DBF	D0,.LOOP2
.NO_MORE_NEEDED:
	RTS

DEVIATION:	DC.W	0

CALC_PLAY_AREA:
	BSR	CLEAN_ARRAY_A

	MOVE.W	CREATION_STYLE(PC),D0
	CMP.W	#2,D0
	BEQ	.NO_MORE_NEEDED
	CMP.W	#4,D0
	BEQ	MAKE_TRENCH_BASIS

	BSR	CLEAN_COLOR_ARRAY_THINGY

	LEA	COLOR_ARRAY,A0			*FIRST MAKE INITIAL LINES
	BSR	CALC_ARRAY

	LEA	COLOR_ARRAY+(((GRID_SIZE+1)*2)*GRID_SIZE),A0
	LEA	MAP_ARRAY_END-((GRID_SIZE+1)*2),A1	
	MOVEQ	#GRID_SIZE,D0
.LOOP:
	MOVE.L	D0,-(A7)		*NOW COPY EACH LINE ONTO EVERY 
	MOVEM.L	(A0),D0-D7/A2-A6	*16TH LINE OF THE MAP ARRAY
	MOVEM.L	D0-D7/A2-A6,(A1)
	MOVEM.W	52(A0),D0-D6
	MOVEM.W	D0-D6,52(A1)
	LEA	-(GRID_SIZE+1)*2(A0),A0
	LEA	-((GRID_SIZE+1)*2)*16(A1),A1	
	MOVE.L	(A7)+,D0
	DBF	D0,.LOOP

	BSR	CLEAN_ARRAY_B

**************THIS LITTLE GEM MAKES A VERY DEEP CANNYON THROUGH************
**************ANY FRACTAL. SET UP USING CREATION STYLE IN MENU!************

	CMP.W	#3,CREATION_STYLE
	BNE	.NO_DEEP_CANYON
	MOVE.L	#GRID_SIZE*16,D7	THIS MAKES LEFT AND RIGHT EDGE
	LEA	MAP_ARRAY+GRID_SIZE,A3
	MOVE.W	WATER_LEVEL(PC),D2
.LOOP2:
	BSR	RANDOM
	AND.L	#$3,D0
	BEQ.S	.NO_CHANGE
	CMP.W	#1,D0
	BEQ.S	.NO_CHANGE
	CMP.W	#2,D0
	BEQ.S	.LEFT
	ADDQ.W	#2,DEVIATION
	BRA.S	.OVER
.LEFT	SUBQ.W	#2,DEVIATION
.OVER	CMP.W	#22,DEVIATION
	BLT.S	.OK
	MOVE.W	#20,DEVIATION
.OK	CMP.W	#-22,DEVIATION
	BGT.S	.NO_CHANGE
	MOVE.W	#-20,DEVIATION
.NO_CHANGE
	MOVE.W	DEVIATION(PC),D0
	LEA	(A3,D0.W),A4
	MOVE.W	D2,(A4)
	MOVE.W	D2,-2(A4)
	MOVE.W	D2,2(A4)
	MOVE.W	D2,-4(A4)
	MOVE.W	D2,4(A4)
	MOVE.W	D2,6(A4)
	MOVE.W	D2,-6(A4)
	LEA	(GRID_SIZE+1)*2(A3),A3
	DBF	D7,.LOOP2

.NO_DEEP_CANYON:
	MOVEQ	#(GRID_SIZE/2)-1,D0
	LEA	MAP_ARRAY,A0
.FINAL_MAKE_LOOP:
	MOVE.L	D0,-(A7)
	BSR	CALC_ARRAY
	MOVE.L	(A7)+,D0
	LEA	((GRID_SIZE+1)*2)*32(A0),A0
	DBF	D0,.FINAL_MAKE_LOOP

.NO_MORE_NEEDED:
	BSR	CONVERT_FORMAT

	RTS

MAKE_TRENCH_BASIS:
	LEA	MAP_ARRAY,A0
	LEA	COLOR_ARRAY,A1
	MOVEQ	#5,D7
	MOVE.W	#512,D0
.LOOPT:	
	MOVE.W	#10,D1
.LOOP1C:
	MOVE.W	#-26,(A0)+
	DBF	D1,.LOOP1C
	MOVE.W	#10,D1
.LOOP2C:
	MOVE.W	#240,(A0)+
	DBF	D1,.LOOP2C
	MOVE.W	#10,D1
.LOOP3:	MOVE.W	#-26,(A0)+
	DBF	D1,.LOOP3
	MOVE.W	#9,D1
.LOOP1B:
	MOVE.B	#0,(A1)+
	DBF	D1,.LOOP1B
	MOVE.B	D7,(A1)+
	MOVE.W	#9,D1
.LOOP2B:
	MOVE.B	#0,(A1)+
	DBF	D1,.LOOP2B
	MOVE.B	D7,(A1)+
	MOVE.W	#9,D1
.LOOP3B:
	MOVE.B	#0,(A1)+
	DBF	D1,.LOOP3B
	CMP.W	#5,D7
	BEQ.S	.END1
	MOVEQ	#5,D7
	DBF	D0,.LOOPT
	RTS
.END1:	MOVEQ	#6,D7
	DBF	D0,.LOOPT
	RTS

****************************************************
*   PROCEDURE TO CALCULATE THE INITIAL GRID FOR    *
* THE GAME AREA (IE EVERY 32 LINE IS ASSIGNED VALS)*
****************************************************

CALC_ARRAY:
	LEA	GRID_MULT_TABLE,A5
	MOVEQ	#GRID_SIZE,D0		D0 = SIZE
	MOVE.W	RANDOM_FAC(PC),D1		D1 = RANDOM FACTOR
	LSR.W	#1,D0			
.LOOP:
	LSR.W	#1,D1
	MOVEQ	#0,D3			D3 = Y COORD = 0
.LOOP1:
	MOVEQ	#0,D2			D2 = X COORD = 0
.LOOP2:
	MOVEQ	#0,D4
	MOVEQ	#0,D5
	MOVE.W	D3,D4
	ADD.W	D4,D4			*TABLE MULTIPLICATION
	ADD.W	D4,D4			*
	MOVE.L	(A5,D4.L),D4		*
	MOVE.W	D2,D5
	ADD.W	D5,D5
	ADD.L	D4,D5
	MOVE.W	(A0,D5.L),D6
	CMP.W	LAND_LEVEL,D6
	BNE.S	.NO_CALC
	MOVEM.L	D0-D3/D7,-(SP)
	BSR.S	DO_CALC
	MOVEM.L	(SP)+,D0-D3/D7
.NO_CALC:
	ADD.W	D0,D2
	CMP.W	#GRID_SIZE,D2
	BLE.S	.LOOP2
	
	ADD.W	D0,D3
	CMP.W	#GRID_SIZE,D3
	BLE.S	.LOOP1		

	LSR.W	#1,D0
	BNE.S	.LOOP
	RTS

************************************************
* THIS ROUTINE DOES THAT ACTUAL CALCULATION OF *
* THE MAP ARRAY POINTS (IE THE FRACTAL)        *
************************************************

*	D0 = SIZE
*	D1 = RANDOM FACTOR
*	D2 = X
*  	D3 = Y

DO_CALC:
	MOVE.W	D3,D5
	SUB.W	D0,D5			Y1%
	TST.W	D5
	BPL.S	.NEXT_OPT
******* POINT ON THE TOP BORDER *******
	MOVE.W	D2,D4			
	SUB.W	D0,D4			X1%
	MOVE.W	D2,D6
	ADD.W	D0,D6			X2%
	MOVEQ	#0,D5			Y1%
	MOVEQ	#0,D7			Y2%
	MOVEM.W	D4-D7,-(SP)		move x1,y1 & x2,y2 onto stack	
	MOVEM.W	D4-D7,-(SP)		move x3,y3 & x4,y4 onto stack
	BRA.S	CALC_IT
.NEXT_OPT:
	MOVE.W	D2,D4
	SUB.W	D0,D4
	TST.W	D4			X1%
	BPL.S	.NEXT_OPT1
******* ON THE LEFT BORDER *******
	MOVE.W	D3,D5
	SUB.W	D0,D5			Y1%
	MOVE.W	D3,D7
	ADD.W	D0,D7			Y2%
	MOVEQ	#0,D4			X1%
	MOVEQ	#0,D6			X2%
	MOVEM.W	D4-D7,-(SP)
	MOVEM.W	D4-D7,-(SP)
	BRA.S	CALC_IT
.NEXT_OPT1:
	MOVE.W	D3,D7
	ADD.W	D0,D7			Y2%
	CMP.W	#GRID_SIZE,D7
	BLE.S	.NEXT_OPT2
******* ON THE LOWER BORDER *******
	MOVE.W	D2,D4
	SUB.W	D0,D4			X1%
	MOVE.W	D2,D6
	ADD.W	D0,D6			X2%
	MOVE.W	#GRID_SIZE,D5		Y1%
	MOVE.W	#GRID_SIZE,D7		Y2%
	MOVEM.W	D4-D7,-(SP)
	MOVEM.W	D4-D7,-(SP)
	BRA.S	CALC_IT
.NEXT_OPT2:
	MOVE.W	D2,D6
	ADD.W	D0,D6			X2%
	CMP.W	#GRID_SIZE,D6
	BLE.S	.NEXT_OPT3
******* ON THE RIGHT BORDER *******
	MOVE.W	#GRID_SIZE,D4		X1%
	MOVE.W	#GRID_SIZE,D6		X2%
	MOVE.W	D3,D5
	SUB.W	D0,D5			Y1%
	MOVE.W	D3,D7
	ADD.W	D0,D7			Y2%
	MOVEM.W	D4-D7,-(SP)
	MOVEM.W	D4-D7,-(SP)
	BRA.S	CALC_IT
.NEXT_OPT3
	MOVEM.W	D4-D7,-(SP)
	EXG	D4,D6
	MOVEM.W	D4-D7,-(SP)
CALC_IT:
	MOVEM.W	D0-D3,-(SP)
	MOVEM.W	(SP)+,A1-A4

	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	12(A7),D0-D1		X2,Y2
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	MOVE.W	(A0,D1.L),D2
	CMP.W	LAND_LEVEL,D2
	BNE.S	.NEXT_OPT1
	MOVE.W	A3,D4			X1%
	MOVE.W	A3,D6			X2%
	MOVE.W	A4,D5
	SUB.W	A1,D5			Y1%
	MOVE.W	A4,D7
	ADD.W	A1,D7			Y2%
	MOVEM.W	D4-D7,(A7)
	MOVEM.W	D4-D7,8(A7)
.NEXT_OPT1:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	4(A7),D0-D1		X3,Y3
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	MOVE.W	(A0,D1.L),D2
	CMP.W	LAND_LEVEL,D2
	BNE.S	.NEXT_OPT2
	MOVE.W	A3,D4
	SUB.W	A1,D4			X1%
	MOVE.W	A3,D6
	ADD.W	A1,D6			X2%
	MOVE.W	A4,D5
	MOVE.W	A4,D7
	MOVEM.W	D4-D7,(A7)
	MOVEM.W	D4-D7,8(A7)
.NEXT_OPT2:

FINAL_CALC:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X1,Y1
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0	
	ADD.L	D0,D1
	MOVE.W	(A0,D1.L),D2
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X2,Y2
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	ADD.W	(A0,D1.L),D2
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X3,Y3
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	ADD.W	(A0,D1.L),D2
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEM.W	(A7)+,D0-D1		X4,Y4
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	ADD.W	(A0,D1.L),D2
	LSR.W	#2,D2			/4

	BSR	RANDOM

	MOVE.W	A2,D1			*MAKE UP THE RANDOM NUMBER
	ADD.W	D1,D1			*ACCORDING TO THE 
	MULU	D1,D0			*CURRENT RANDOM FACTOR
	SWAP	D0			*
	SUB.W	A2,D0			*THIS ENSURES + & - NUMBERS

	ADD.W	D0,D2			*ADD THE RANDOM FACTOR
	BPL.S	.NOT_NEG

	MOVEQ	#0,D2
.NOT_NEG:
	CMP.W	LAND_LEVEL,D2
	BNE.S	.NOT_INITIAL
	ADDQ.W	#1,D2
.NOT_INITIAL:
	CMP.W	#4096,D2
	BLT.S	.IN_RANGE
	MOVE.W	#4095,D2
.IN_RANGE

	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.W	A3,D0
	MOVE.W	A4,D1
	ADD.W	D1,D1			*TABLE MULTIPLICATION
	ADD.W	D1,D1			*
	MOVE.L	(A5,D1.L),D1		*
	ADD.W	D0,D0
	ADD.L	D0,D1
	AND.W	#%0000111111111111,D2
	MOVE.W	D2,(A0,D1.L)
	RTS

*******************************************
* CONVERTS FORMAT OF POINTS INTO ONE WHICH*
* CAN BE MORE QUICKLY TURNED INTO A 3D    *
* POINT.                                  *
*******************************************

CONVERT_FORMAT:
**********PUT ALL AT SEA LEVEL AND ABOVE**********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
.LOOP1
	MOVE.W	(A0),D3
	SUB.W	WATER_LEVEL,D3
	BPL.S	.ITS_ALRIGHT
	MOVEQ	#0,D3
.ITS_ALRIGHT:
	MOVE.W	D3,(A0)+
	CMP.L	A0,A1
	BNE.S	.LOOP1
*************************************************

*********CONVERT INTO EASY FORMAT FOR CALCS******
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
.LOOP3
	MOVE.W	(A0),D3
	LSR.W	#3,D3
	NEG.W	D3
	BEQ.S	.DATA_OK
*********NEW LIMITER CODE TO PREVENT HEIGHT ERRORS***************
	CMP.W	#$FEF0,D3
	BGE.S	.DATA_OK
	MOVE.W	#$FEF0,D3
.DATA_OK:
	MOVE.W	D3,(A0)+
	CMP.L	A0,A1
	BNE.S	.LOOP3
*************************************************

	MOVE.W	FILL_STYLES(PC),D0
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	FILL_STYLES_TAB(PC,D0.W),A0
	JSR	(A0)
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	MOVE.W	#240,D0
.LOOP:	ADD.W	D0,(A0)+
	CMP.L	A1,A0
	BNE.S	.LOOP
	RTS

FILL_STYLES_TAB:
	DC.L	0
	DC.L	DO_HEIGHT_COLORSA
	DC.L	DO_HEIGHT_COLORSB
	DC.L	DO_HEIGHT_COLORSA		*SPARE SLOT
	DC.L	DO_LIGHT

DO_HEIGHT_COLORSA:
**********CREATE COLOR ARRAY FROM DATA***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	LEA	COLOR_TABLE_1(PC),A3
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	ADD.W	66(A0),D3
	ADD.W	68(A0),D3
	NEG.W	D3

	LSR.W	#2,D3
	TST.W	D3
	BGT.S	.OOPS1
	MOVE.B	#0,(A2)+
	ADDQ.L	#2,A0
	BRA.S	.OKA
.OOPS1:
	LSR.W	#5,D3
	MOVE.B	(A3,D3.W),(A2)+
	ADDQ.L	#2,A0
.OKA	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	MOVE.W	#1,FILL_STYLES
	RTS

DO_HEIGHT_COLORSB:
**********CREATE COLOR ARRAY FROM DATA***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	LEA	COLOR_TABLE_1(PC),A3
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	ADD.W	66(A0),D3
	ADD.W	68(A0),D3
	NEG.W	D3

	LSR.W	#2,D3
	TST.W	D3
	BGT.S	.OOPS1
	MOVE.B	#0,(A2)+
	ADDQ.L	#2,A0
	BRA.S	.OKA
.OOPS1:
	MOVE.W	(A0)+,D3
	NEG.W	D3
	LSR.W	#5,D3
	MOVE.B	(A3,D3.W),(A2)+
.OKA	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	MOVE.W	#2,FILL_STYLES
	RTS

COLOR_TABLE_1:
	DC.B	1,15,1+8,2,16,2+8,2+8,2+8,2+8,2+8,2+8,2+8,2+8,2+8,2+8,2+8
	EVEN

DO_LIGHT:
**********CREATE COLOR ARRAY FROM DATA***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	MOVE.W	66(A0),D4
	ADD.W	68(A0),D4

	ASR.W	#5,D3
	ASR.W	#5,D4

	SUB.W	D3,D4

	MOVE.W	(A0),D1
	ADD.W	66(A0),D1
	MOVE.W	2(A0),D2
	ADD.W	68(A0),D2

	ASR.W	#5,D1
	ASR.W	#5,D2

	SUB.W	D1,D2
	
	ADD.W	D2,D4

	ADDQ.W	#3,D4
	CMP.W	#1,D4
	BGE.S	.PLUS
	MOVEQ	#1,D4
	BRA.S	.OK
.PLUS	CMP.W	#6,D4
	BLE.S	.OK
	MOVEQ	#6,D4
.OK
	MOVE.B	D4,(A2)+
	ADDQ.L	#2,A0
	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	MOVE.W	#4,FILL_STYLES
CORRECT_WATER:
**********PUT WATER COLOR IN CORRECTLY***********
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END,A1
	LEA	COLOR_ARRAY,A2
	LEA	COLOR_TABLE_1(PC),A3
	MOVE.W	#(GRID_SIZE*(GRID_SIZE/2))-1,D6
.LOOP2A:
	MOVE.W	#(GRID_SIZE)-1,D5
.LOOP2B:
	MOVEQ	#0,D3
	
	MOVE.W	(A0),D3
	ADD.W	2(A0),D3
	ADD.W	66(A0),D3
	ADD.W	68(A0),D3
	NEG.W	D3

	LSR.W	#2,D3
	TST.W	D3
	BGT.S	.OOPS1
	MOVE.B	#0,(A2)+
	ADDQ.L	#2,A0
	BRA.S	.OKA
.OOPS1:
	ADDQ.L	#1,A2
	ADDQ.L	#2,A0
.OKA	DBF	D5,.LOOP2B
	ADDQ.L	#2,A0
	DBF	D6,.LOOP2A
*************************************************
	RTS

*********************************************
* RECREATE FRACTAL FROM COMPRESSED DATA     *
*********************************************
* TOO COMPLICATED REWRITE LATER!

DECOMPRESS_DATA:
	LEA	MAP_ARRAY,A0
	LEA	DATA_BUFFER,A1
.LOOP
	MOVEQ	#0,D0
	MOVE.W	(A1)+,D0
	CMP.W	#-1,D0
	BEQ.S	.END_OF_DATA
	CMP.L	#16929,D0
	BLT.S	.OK
	CMP.L	#25138,D0
	BLT.S	.OK2
	LEA	OBJECT_ARRAY-50274,A0
	ADD.L	D0,D0
	MOVE.L	(A1)+,D1
	MOVE.L	D1,(A0,D0.L)
	BRA.S	.LOOP
.OK2:
	LEA	COLOR_ARRAY-33858,A0
	ADD.L	D0,D0
	MOVE.L	(A1)+,D1
	MOVE.L	D1,(A0,D0.L)
	BRA.S	.LOOP
.OK	ADD.L	D0,D0
	MOVE.L	(A1)+,D1
	SWAP	D1
	ADD.W	#240,D1
	SWAP	D1
	ADD.W	#240,D1
	MOVE.L	D1,(A0,D0.L)
	BRA.S	.LOOP
.END_OF_DATA:
	RTS

*********************************************
* MAKES UP OVERLAP AREA IN FRACTAL SO THAT  *
* CONTINUOUS FLYING IS POSSIBLE             *
*********************************************

CREATE_OVERLAP:
	LEA	MAP_ARRAY,A0
	LEA	MAP_ARRAY_END-((GRID_SIZE+1)*2),A1
	MOVE.W	#((GRID_SIZE+1)*32)-1,D0
.LOOP1:	MOVE.W	(A0)+,(A1)+
	DBF	D0,.LOOP1

	LEA	COLOR_ARRAY,A0
	LEA	COLOR_ARRAY_END-GRID_SIZE,A1
	MOVE.W	#((GRID_SIZE)*16)-1,D0
.LOOP2:	MOVE.W	(A0)+,(A1)+
	DBF	D0,.LOOP2
	RTS

*********************************************
* LOAD MAP ROUTINE                          *
* A0 = FILENAME                             *
*********************************************

LOAD_FILE:
	IFEQ	DMA
	BSET	#5,$FFFFFA09.W
	ENDC
	MOVE.W	#0,-(SP)
	MOVE.L	A0,-(SP)
	MOVE.W	#$3D,-(SP)
	TRAP	#1
	ADDQ.L	#8,SP
	TST.W	D0
	BMI.S	.ERROR
	MOVE.W	D0,.HANDLE

	MOVE.L	#START_OF_DATA,-(SP)
	MOVE.L	#512,-(SP)
	MOVE.W	.HANDLE,-(SP)	
	MOVE.W	#$3F,-(SP)
	TRAP	#1
	ADD.L	#12,SP

	MOVE.L	#DATA_BUFFER,-(SP)
	MOVE.L	#$FFFFF,-(SP)
	MOVE.W	.HANDLE,-(SP)	
	MOVE.W	#$3F,-(SP)
	TRAP	#1
	ADD.L	#12,SP

	MOVE.W	.HANDLE,-(SP)
	MOVE.W	#$3E,-(SP)
	TRAP	#1
	ADDQ.L	#4,SP

	BSR	CALC_PLAY_AREA
	BSR	DECOMPRESS_DATA
	BSR	CREATE_OVERLAP
	BSR	SET_UP_RASTERS
	BSR.S	GET_SHIP_PRESETS
	BSR.S	DO_MAP_2D
	RTS

.ERROR:
	BRA	QUIT

.HANDLE:	DC.W	0

GET_SHIP_PRESETS:
	MOVE.W	SHIP_START_X(PC),D0
	SWAP	D0
	CLR.W	D0
	MOVE.L	D0,CURRENT_SHIP_X
	SUB.L	#$58000,D0
	BPL.S	.OK
	MOVEQ	#0,D0
.OK:	CMP.L	#$150000,D0
	BLE.S	.OK2
	MOVE.L	#$150000,D0
.OK2:	MOVE.L	D0,CURRENT_POS_X
	MOVE.W	SHIP_START_Z(PC),D0
	SUBQ.W	#8,D0
	MOVE.W	D0,CURRENT_POS_Z
	MOVE.W	#0,CURRENT_POS_Z+2
	MOVE.W	#30,CURRENT_POS_Y
	MOVE.W	#0,CURRENT_POS_Y+2
	RTS

***************************************
* MAKE A 2D REPRESENTATION OF THE MAP *
***************************************

DO_MAP_2D:
	LEA	COLOR_ARRAY,A0		ADDRESS OF COLOR DATA
	LEA	MAP_IN_2D+(17*16),A3	SPACE FOR MAP
	LEA	COLOR_DATA(PC),A1	DRAW CODE
	LEA	.MARK1(PC),A2		PLACE TO PUT DRAW CODE
	LEA	POINT_TABLE(PC),A6
	MOVEQ	#0,D5

	MOVE.L	#511,D7			HOW MAY LINES TO BE DRAWN OUT	
.LOOP1:
	LEA	(A3,D5.W),A5
	MOVEQ	#0,D2
	MOVE.L	D2,(A5)+
	MOVE.L	D2,(A5)+
	MOVE.L	D2,(A5)+
	MOVE.L	D2,(A5)+
	MOVEQ	#GRID_SIZE-1,D6
.LOOP2:
	MOVEQ	#0,D2
	MOVE.B	(A0)+,D2
	LSL.W	#3,D2
	LEA	(A1,D2.W),A5

	MOVE.L	(A5)+,(A2)		MODIFY THE CODE
	MOVE.L	(A5)+,4(A2)

	MOVEQ	#0,D1
	MOVE.W	D6,D1			GET DOT POSITION
	NEG.W	D1
	ADD.W	#31,D1
	MOVE.W	D1,D2			AND ISOLATE POINT DATA
	AND.L	#$F,D2
	SUB.W	D2,D1
	LSR.W	#1,D1
	ADD.W	D2,D2
	ADD.L	D5,D1

	MOVE.W	(A6,D2.W),D0		GET POINT DATA
	MOVE.W	D0,D2			
	NOT.W	D2			AND MAKE MASK

	LEA	(A3,D1.L),A5		GET SCREEN POSITION

.MARK1	OR.W	D0,(A5)+		SELF MODIFYING CODE FOR
	OR.W	D0,(A5)+		COLOR PLOT
	OR.W	D0,(A5)+
	AND.W	D2,(A5)+

	DBF	D6,.LOOP2
	ADD.W	#16,D5
	DBF	D7,.LOOP1

	LEA	MAP_IN_2D+(17*16),A0
	LEA	MAP_IN_2D+((512+17)*16),A1
	MOVEQ	#14,D7	
	BSR.S	QUICK_COPY
	LEA	MAP_IN_2D+(512*16),A0
	LEA	MAP_IN_2D,A1
	MOVEQ	#16,D7	
	BSR.S	QUICK_COPY
	RTS

QUICK_COPY:
	MOVEM.L	(A0)+,D0-D3
	MOVEM.L	D0-D3,(A1)
	LEA	16(A1),A1
	DBF	D7,QUICK_COPY
	RTS

ANDD:		EQU	$C25D
ORD:		EQU	$815D
	
COLOR_DATA:
*	DC.W	ORD,ANDD,ANDD,ANDD
*	DC.W	ANDD,ORD,ANDD,ANDD
*	DC.W	ORD,ORD,ANDD,ANDD
*	DC.W	ANDD,ANDD,ORD,ANDD
*	DC.W	ORD,ANDD,ORD,ANDD
*	DC.W	ANDD,ORD,ORD,ANDD
*	DC.W	ORD,ORD,ORD,ANDD
*	DC.W	ANDD,ANDD,ANDD,ORD
*	DC.W	ORD,ANDD,ANDD,ORD
*	DC.W	ANDD,ORD,ANDD,ORD
*	DC.W	ORD,ORD,ANDD,ORD
*	DC.W	ANDD,ANDD,ORD,ORD
*	DC.W	ORD,ANDD,ORD,ORD
*	DC.W	ANDD,ORD,ORD,ORD
*	DC.W	ORD,ORD,ORD,ORD
*	DC.W	ANDD,ORD,ANDD,ANDD
*	DC.W	ORD,ORD,ANDD,ANDD

	DC.W	ORD,ANDD,ANDD,ANDD
	DC.W	ANDD,ORD,ANDD,ANDD
	DC.W	ANDD,ORD,ANDD,ANDD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ORD,ORD,ANDD,ANDD
	DC.W	ORD,ORD,ANDD,ANDD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ANDD,ANDD,ORD
	DC.W	ANDD,ORD,ANDD,ANDD
	DC.W	ORD,ORD,ANDD,ANDD

POINT_TABLE:
	DC.W	%1000000000000000
	DC.W	%0100000000000000
	DC.W	%0010000000000000
	DC.W	%0001000000000000
	DC.W	%0000100000000000
	DC.W	%0000010000000000
	DC.W	%0000001000000000
	DC.W	%0000000100000000
	DC.W	%0000000010000000
	DC.W	%0000000001000000
	DC.W	%0000000000100000
	DC.W	%0000000000010000
	DC.W	%0000000000001000
	DC.W	%0000000000000100
	DC.W	%0000000000000010
	DC.W	%0000000000000001
	
CLEAR_LOGBASE:
	MOVE.L	LOGBASE(PC),A0
	ADD.W	#(Y_MIDDLE+108)*160,A0
	MOVEM.L	ERASE_MASK(PC),D0-D7/A1-A6

	REPT	422
	MOVEM.L	D0-D7/A1-A6,-(A0)
	ENDR
	MOVEM.L	D0-D7/A1-A4,-(A0)

DO_SIDES:
	MOVE.L	LOGBASE(PC),A0
	MOVEQ	#0,D7
START_CODE_HERE:
	DS.W	1000

ERASE_MASK:
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000
	DC.L	$FFFF0000,00000000

ERASE_MASK2:	
	DS.L	16

************************************************
* ROUTINE TO LOOK AFTER THE CONTROL PANEL      *
************************************************

DO_CONTROL_PANEL:
*************** ROUTINE FOR ENERGY *****************
	MOVEM.L	ERASE_MASK2(PC),D0-D7/A0-A5
	MOVE.L	LOGBASE(PC),A6
	LEA	((CONTROL_PANEL_Y+21)*160)+8(A6),A6
	MOVEM.L	D0-D7/A0-A5,(A6)
	MOVEM.L	D0-D7/A0-A5,160(A6)
	MOVEM.L	D0-D7/A0-A5,320(A6)
	MOVEM.L	D0-D7/A0-A5,480(A6)
	MOVE.W	ENERGY(PC),D2
	BSR	DRAW_GFX_BAR

*************** ROUTINE FOR SPEED *****************
	MOVEM.L	ERASE_MASK2(PC),D0-D7/A0-A5
	MOVE.L	LOGBASE(PC),A6
	LEA	((CONTROL_PANEL_Y+7)*160)+8(A6),A6
	MOVEM.L	D0-D7/A0-A5,(A6)
	MOVEM.L	D0-D7/A0-A5,160(A6)
	MOVEM.L	D0-D7/A0-A5,320(A6)
	MOVEM.L	D0-D7/A0-A5,480(A6)
	MOVE.L	Z_ACC(PC),D2
	LSL.L	#7,D2
	SWAP	D2
	NEG.W	D2
	CMP.W	#111,D2
	BLT.S	.OK_ITS_IN_RANGE
	MOVEQ	#111,D2
.OK_ITS_IN_RANGE:
	BSR	DRAW_GFX_BAR

*******ROUTINE FOR VELOCITY OVERRIDE INDICATOR******
	MOVE.W	VEL_OVERRIDE,D0
	CMP.W	OLD_VO_IND(PC),D0
	BEQ.S	.NO_CHANGE
	MOVE.W	D0,OLD_VO_IND
	TST.W	D0
	BEQ.S	.NO_OVER
 	LEA	PANEL_IND_GFX+(11*16),A1
	BRA.S	.DRAW_IND
.NO_OVER:
	LEA	PANEL_IND_GFX,A1
.DRAW_IND:
	MOVE.L	A1,A2
	LEA	SCREEN1+((CONTROL_PANEL_Y+7)*160)+64,A0
	BSR	DRAW_VO_IND
	MOVE.L	A1,A2
	LEA	SCREEN2+((CONTROL_PANEL_Y+7)*160)+64,A0
	BSR	DRAW_VO_IND
	MOVE.L	A1,A2
	LEA	SCREEN3+((CONTROL_PANEL_Y+7)*160)+64,A0
	BSR	DRAW_VO_IND
.NO_CHANGE:
*****************DRAW THE MAP*******************	
	MOVE.L	 LOGBASE(PC),A0
	LEA	(CONTROL_PANEL_Y*160)+144(A0),A0
	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS_Z(PC),D0
	SUB.L	#17,D0
	ASL.L	#4,D0
	LEA	MAP_IN_2D+(17*16),A1
	ADD.L	D0,A1
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,(A0)
	MOVEM.L	D4-D7,160(A0)
	MOVEM.L	A2-A5,320(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,480(A0)
	MOVEM.L	D4-D7,640(A0)
	MOVEM.L	A2-A5,800(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,960(A0)
	MOVEM.L	D4-D7,1120(A0)
	MOVEM.L	A2-A5,1280(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,1440(A0)
	MOVEM.L	D4-D7,1600(A0)
	MOVEM.L	A2-A5,1760(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,1920(A0)
	MOVEM.L	D4-D7,2080(A0)
	MOVEM.L	A2-A5,2240(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,2400(A0)
	MOVEM.L	D4-D7,2560(A0)
	MOVEM.L	A2-A5,2720(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,2880(A0)
	MOVEM.L	D4-D7,3040(A0)
	MOVEM.L	A2-A5,3200(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,3360(A0)
	MOVEM.L	D4-D7,3520(A0)
	MOVEM.L	A2-A5,3680(A0)
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,3840(A0)
	MOVEM.L	D4-D7,4000(A0)
	MOVEM.L	A2-A5,4160(A0)
	MOVE.W	CURRENT_SHIP_X(PC),D0	DRAW ON SHIP DOT
	LEA	4160(A0),A2
	MOVE.W	D0,D1
	AND.W	#15,D0
	SUB.W	D0,D1
	LSR.W	#1,D1
	ADD.W	D1,A2
	ADD.W	D0,D0
	LEA	POINT_TABLE(PC),A3
	MOVE.W	(A3,D0.W),D0
	MOVE.W	D0,D1
	NOT.W	D1
	AND.W	D1,(A2)+	
	AND.W	D1,(A2)+	
	OR.W	D0,(A2)+	
	OR.W	D0,(A2)+	
	MOVEM.L	(A1)+,D0-D7/A2-A5
	MOVEM.L	D0-D3,4320(A0)
	MOVEM.L	D4-D7,4480(A0)
	MOVEM.L	A2-A5,4640(A0)
	MOVEM.L	(A1)+,D0-D7
	MOVEM.L	D0-D3,4800(A0)
	MOVEM.L	D4-D7,4960(A0)

*************** ROUTINE FOR SCORE ******************
	MOVE.L	LOGBASE(PC),A0
	LEA	((SCORE_PANEL_Y+2)*160)+16(A0),A0	SCORE POSITION
	MOVE.L	SCORE(PC),D0
	LEA	DECIMAL_CONVERT(PC),A1
	
	MOVEQ	#0,D2
	MOVE.L	(A1)+,D1		100000
.LOOP1	CMP.L	D1,D0
	BLT.S	.DRAW1
	ADDQ.W	#1,D2
	SUB.L	D1,D0
	BRA.S	.LOOP1
.DRAW1:
	BSR.S	DRAW_BYTE1
	MOVEQ	#0,D2
	MOVE.L	(A1)+,D1		10000
.LOOP2	CMP.L	D1,D0
	BLT.S	.DRAW2
	ADDQ.W	#1,D2
	SUB.L	D1,D0
	BRA.S	.LOOP2
.DRAW2:
	BSR	DRAW_BYTE2
	ADDQ.W	#8,A0
	MOVEQ	#0,D2
	MOVE.L	(A1)+,D1		1000
.LOOP3	CMP.L	D1,D0
	BLT.S	.DRAW3
	ADDQ.W	#1,D2
	SUB.L	D1,D0
	BRA.S	.LOOP3
.DRAW3:
	BSR.S	DRAW_BYTE1
	MOVEQ	#0,D2
	MOVE.L	(A1)+,D1		100
.LOOP4	CMP.L	D1,D0
	BLT.S	.DRAW4
	ADDQ.W	#1,D2
	SUB.L	D1,D0
	BRA.S	.LOOP4
.DRAW4:
	BSR.S	DRAW_BYTE2
	ADDQ.W	#8,A0
	MOVEQ	#0,D2
	MOVE.L	(A1)+,D1		10
.LOOP5	CMP.L	D1,D0
	BLT.S	.DRAW5
	ADDQ.W	#1,D2
	SUB.L	D1,D0
	BRA.S	.LOOP5
.DRAW5:
	BSR.S	DRAW_BYTE1
	MOVE.L	D0,D2
	BSR.S	DRAW_BYTE2		1
	RTS


DECIMAL_CONVERT:
	DC.L	100000
	DC.L	10000
	DC.L	1000
	DC.L	100
	DC.L	10
	DC.L	1

DRAW_BYTE1:
	LEA	NUMBERS_6,A6
	LSL.W	#4,D2
	ADD.W	D2,A6
	ADD.W	D2,D2
	ADD.W	D2,A6
DRAW_BYTE1B
	MOVE.B	(A6),2(A0)
	MOVE.B	8(A6),162(A0)
	MOVE.B	16(A6),322(A0)
	MOVE.B	24(A6),482(A0)
	MOVE.B	32(A6),642(A0)
	MOVE.B	40(A6),802(A0)
	RTS

DRAW_BYTE2:
	LEA	NUMBERS_6,A6
	LSL.W	#4,D2
	ADD.W	D2,A6
	ADD.W	D2,D2
	ADD.W	D2,A6
DRAW_BYTE2B:
	MOVE.B	(A6),3(A0)
	MOVE.B	8(A6),163(A0)
	MOVE.B	16(A6),323(A0)
	MOVE.B	24(A6),483(A0)
	MOVE.B	32(A6),643(A0)
	MOVE.B	40(A6),803(A0)
	RTS

OLD_VO_IND:	DC.W	0

DRAW_VO_IND:
	MOVEM.L	(A2)+,D0-D7/A3-A6
	MOVEM.L	D0-D3,(A0)
	MOVEM.L	D4-D7,160(A0)
	MOVEM.L	A3-A6,320(A0)
	MOVEM.L	(A2)+,D0-D7/A3-A6
	MOVEM.L	D0-D3,480(A0)
	MOVEM.L	D4-D7,640(A0)
	MOVEM.L	A3-A6,800(A0)
	MOVEM.L	(A2)+,D0-D7/A3-A6
	MOVEM.L	D0-D3,960(A0)
	MOVEM.L	D4-D7,1120(A0)
	MOVEM.L	A3-A6,1280(A0)
	MOVEM.L	(A2)+,D0-D7
	MOVEM.L	D0-D3,1440(A0)
	MOVEM.L	D4-D7,1600(A0)
	RTS

DRAW_GFX_BAR:
	MOVE.W	D2,D1
	AND.W	#15,D1
	SUB.W	D1,D2			GET RIGHT X WORD BOUNDARY
	ADD.W	D1,D1
	LEA	LEFT_MASKS+64(PC),A0
	MOVE.W	(A0,D1.W),A5		RIGHT MASK
	LEA	PANEL_ENERGY,A2
	CMP.W	#16,D2
	BLT	.ONE_WORD1
	ADD.W	D2,D2
	NEG.W	D2
	LEA	.ONE_WORD1(PC),A4
	JMP	(A4,D2.W)
	REPT	7
	MOVEM.L	(A2)+,D0-D7
	MOVE.L	D6,480(A6)
	MOVE.L	D7,484(A6)
	MOVE.L	D4,320(A6)
	MOVE.L	D5,324(A6)
	MOVE.L	D2,160(A6)
	MOVE.L	D3,164(A6)
	MOVE.L	D0,(A6)+
	MOVE.L	D1,(A6)+
	ENDR
.ONE_WORD1:	
	MOVE.W	A5,D0
	SWAP	D0
	MOVE.W	A5,D0			make long word mask	
	MOVEM.L	(A2)+,D1-D4
	AND.L	D0,D1
	AND.L	D0,D2
	AND.L	D0,D3
	AND.L	D0,D4
	MOVE.L	D1,(A6)+
	MOVE.L	D2,(A6)+
	MOVE.L	D3,152(A6)
	MOVE.L	D4,156(A6)
	MOVEM.L	(A2)+,D1-D4
	AND.L	D0,D1
	AND.L	D0,D2
	AND.L	D0,D3
	AND.L	D0,D4
	MOVE.L	D1,312(A6)
	MOVE.L	D2,316(A6)
	MOVE.L	D3,472(A6)
	MOVE.L	D4,476(A6)
	RTS

************************************************
* THE IMPORTANT ROUTINES                       *
************************************************

CALCULATE_GRID:
	LEA	PROJ_DIVU_TAB,A0
	LEA	OFFSET_ADDS(PC),A6		LEFT SIDE
	MOVEQ	#10,D7

	MOVE.L	CURRENT_POS_Z(PC),D0		GET CURRENT MAP LINE
	LSR.W	D7,D0
	MOVE.W	D0,4(A6)
	MOVEQ	#63,D1
	SUB.W	D0,D1
	MOVE.W	D1,6(A6)

	CLR.W	D0
	SWAP	D0

	ADD.L	D0,D0				*MULU	#66,D0
	MOVE.L	D0,D1
	LSL.L	#5,D0
	ADD.L	D1,D0

	LEA	MAP_ARRAY,A4
	ADD.L	D0,A4
	MOVE.L	A4,8(A6)			SAVE THE BASE MAP POS

	MOVE.L	CURRENT_POS_X(PC),D0
	SWAP	D0
	ADD.W	D0,D0
	ADD.W	D0,A4
	SWAP	D0				ADD SQUARE POS
	LSR.W	D7,D0				THEN WORK OUT SQUARE OFFSET
	MOVE.W	D0,2(A6)
	MOVEQ	#64,D1
	SUB.W	D0,D1
	MOVE.W	D1,(A6)				RIGHT SIDE 64-LEFT_SIDE

	LEA	DRAW_BUFFER,A5
	MOVE.W	#1000,D0			Z COORDINATE
	MOVE.W	D0,D4
	ADD.W	D4,D4
	MOVE.W	(A0,D4.W),D4			TOP OF WATER

	LEA	MULT_VALUE(PC),A1
	MOVE.W	4(A6),D7			GET MULT VALUE
*	SUBQ.W	#1,D7
	LSL.W	#8,D7
	ADD.W	D7,D7				*MULU	#32768/64,D7
	MOVE.W	D7,(A1)
	MOVE.W	(A6),D7				GET MULT VALUE
	SUBQ.W	#1,D7
	LSL.W	#8,D7
	ADD.W	D7,D7				*MULU	#32768/64,D7
	MOVE.W	D7,2(A1)
	MOVE.W	2(A6),D7				GET MULT VALUE
	SUBQ.W	#1,D7
	LSL.W	#8,D7
	ADD.W	D7,D7				*MULU	#32768/64,D7
	MOVE.W	D7,4(A1)
	MOVEQ	#0,D7
	MOVEQ	#0,D5

	BSR	CALCULATE_1_SPECIALB

	MOVEQ	#0,D7
	SUB.W	6(A6),D0
	MOVE.W	D0,CURRENT_START_Z		READY FOR NEW DATA ROUTINE

	REPT	8
	BSR.S	CALCULATE_1_LINE
	SUB.W	#64,D0
	ENDR
	BSR.S	CALCULATE_1_LINE
	SUB.W	4(A6),D0

	LEA	MULT_VALUE(PC),A1
	MOVE.W	6(A6),D7			GET MULT VALUE
	LSL.W	#8,D7
	ADD.W	D7,D7				*MULU	#32768/64,D7
	MOVE.W	D7,(A1)
	MOVEQ	#0,D7

	BSR	CALCULATE_1_SPECIAL

	RTS

MULT_VALUE:	DC.W	0,0,0

CALCULATE_1_LINE:
	MOVE.W	D0,D4
	ADD.W	D4,D4
	MOVE.W	(A0,D4.W),D4			Z FACTOR

	MOVE.W	#-352,D1			X COORDINATE
	MULS	D4,D1
	SWAP	D1

	MOVE.W	(A4)+,A2
	MOVE.W	(A4),D2
	SUB.W	A2,D2
	MULS	4(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2

	MOVE.W	D1,D3
	ADD.W	#160,D3

	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+

	MOVE.W	(A6),D3				ADD LEFT OFFSET
	MULS	D4,D3
	MOVEQ	#64,D6
	MULS	D4,D6
	MOVE.L	D6,D2
	SUB.L	D3,D2
	MOVE.L	D2,A2
	SWAP	D6
	SWAP	D3
	ADD.L	D3,D1
	ADDX.W	D7,D1

	REPT	10
	MOVE.W	(A4)+,D2			Y COORDINATE
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	ADD.L	D6,D1				ADD NORMAL X OFFSET
	ADDX.W	D7,D1
 	ENDR

	MOVE.W	(A4)+,D2			Y COORDINATE
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	MOVE.W	2(A6),D3			ADD RIGHT X OFFSET
	SWAP	D1
	ADD.L	A2,D1
	SWAP	D1
	ADDX.W	D7,D1

	MOVE.W	-2(A4),D2
	MOVE.W	(A4)+,A2			Y COORDINATE
	SUB.W	A2,D2
	MULS	2(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	ADD.W	#160,D1
	MOVE.W	D1,(A5)+
	MOVE.W	D2,(A5)+

	LEA	20*2(A4),A4
	RTS

CALCULATE_1_SPECIAL:
	MOVE.W	D0,D4
	ADD.W	D4,D4
	MOVE.W	(A0,D4.W),D4			Z FACTOR

	MOVE.W	#-352,D1			X COORDINATE

	MOVE.W	-33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2

	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MULS	D4,D1
	SWAP	D1
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	MOVE.W	(A6),D3				ADD LEFT OFFSET
	MULS	D4,D3
	SWAP	D3
	ADD.L	D3,D1
	ADDX.W	D7,D1
	MOVEQ	#64,D6
	MULS	D4,D6
	SWAP	D6

	MOVE.W	-33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2

	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	ADD.L	D6,D1				ADD NORMAL X OFFSET
	ADDX.W	D7,D1

	MOVE.W	-6(A5),A2			GET INTERCEPT POINT FOR LEFT FRONT Y
	MOVE.W	-2(A5),D2
	SUB.W	A2,D2
	MULS	4(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MOVE.W	D2,-6(A5)	

	REPT	9
	MOVE.W	-33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2

	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	ADD.L	D6,D1				ADD NORMAL X OFFSET
	ADDX.W	D7,D1
 	ENDR
	MOVE.W	-33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	MOVE.W	2(A6),D3			ADD RIGHT X OFFSET
	MULS	D4,D3
	SWAP	D3
	ADD.L	D3,D1
	ADDX.W	D7,D1

	MOVE.W	-33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	ADD.W	#160,D1
	MOVE.W	D1,(A5)+
	MOVE.W	D2,(A5)+

	MOVE.W	-6(A5),D2			GET INTERCEPT POINT FOR
	MOVE.W	-2(A5),A2			RIGHT FRONT Y
	SUB.W	A2,D2
	MULS	2(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MOVE.W	D2,-2(A5)	

	LEA	20*2(A4),A4
	RTS

CALCULATE_1_SPECIALB:
	MOVE.W	D0,D4
	ADD.W	D4,D4
	MOVE.W	(A0,D4.W),D4			Z FACTOR

	MOVE.W	#-352,D1			X COORDINATE

	MOVE.W	33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MULS	D4,D1
	SWAP	D1
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	MOVE.W	(A6),D3				ADD LEFT OFFSET
	MULS	D4,D3
	SWAP	D3
	ADD.L	D3,D1
	ADDX.W	D7,D1				ADD INIT OFFSET
	MOVEQ	#64,D6				GET LWI GRID DIST
	MULS	D4,D6
	SWAP	D6

	MOVE.W	33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	ADD.L	D6,D1				ADD NORMAL X OFFSET
	ADDX	D7,D1

	MOVE.W	-6(A5),A2			GET INTERCEPT POINT FOR LEFT FRONT Y
	MOVE.W	-2(A5),D2
	SUB.W	A2,D2
	MULS	4(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MOVE.W	D2,-6(A5)	

	REPT	9
	MOVE.W	33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	ADD.L	D6,D1				ADD NORMAL X OFFSET
	ADDX	D7,D1
 	ENDR
	MOVE.W	33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	MOVE.W	D1,D3
	ADD.W	#160,D3
	MOVE.W	D3,(A5)+
	MOVE.W	D2,(A5)+
	MOVE.W	2(A6),D3			ADD RIGHT X OFFSET
	MULS	D4,D3
	SWAP	D3
	ADD.L	D3,D1
	ADDX.W	D7,D1
	MOVE.W	33*2(A4),D2
	MOVE.W	(A4)+,A2
	SUB.W	A2,D2
	MULS	(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MULS	D4,D2
	SWAP	D2
	ADD.W	#Y_MIDDLE,D2
	ADD.W	#160,D1
	MOVE.W	D1,(A5)+
	MOVE.W	D2,(A5)+

	MOVE.W	-6(A5),D2			GET INTERCEPT POINT FOR
	MOVE.W	-2(A5),A2			RIGHT FRONT Y
	SUB.W	A2,D2
	MULS	2(A1),D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	A2,D2
	MOVE.W	D2,-2(A5)	

	LEA	20*2(A4),A4
	RTS

OFFSET_ADDS:	DC.W	0,0,0,0
BASE_MAP_POS:	DC.L	0

DRAW_3D_VERSION:
	LEA	DRAW_BUFFER,A1
	MOVE.L	#DRAW_LIST9,DRAW_POINT
	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS_Z(PC),D0
	LSL.L	#5,D0
	ADD.W	CURRENT_POS_X(PC),D0
	LEA	COLOR_ARRAY,A2
	ADD.L	D0,A2

	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS_X+2(PC),D0
	LSR.W	#8,D0
	LEA	ROUTINE_TABLE(PC),A4
	MOVE.L	(A4,D0.W),A4
	JSR	(A4)

	MOVE.W	#108+Y_MIDDLE,A4
	LEA	POLY_SURFACES(PC),A0
	
ADDIT	SET	0
	REPT	6
	MOVEM.L	ADDIT/4(A1),D0-D1/D5
	MOVE.L	D1,D4
	MOVE.L	D0,D3
	MOVE.L	D1,D2
	MOVE.L	D4,D7
	MOVE.L	D5,D6
	MOVE.W	A4,D2
	MOVE.W	A4,D3
	MOVE.W	A4,D6
	MOVE.W	A4,D7
	MOVEM.L	D0-D7,ADDIT(A0)
ADDIT	SET	ADDIT+32
	ENDR

	BSR	DRAW_SHIP			draw on the player

ADDIT	SET	0
	REPT	12
	LEA	POLY_SURFACES+ADDIT(PC),A0
	BSR	POLY_FRONT
ADDIT	SET	ADDIT+16
	ENDR
	RTS

NORMAL_LINE:
	LEA	POLY_SURFACES+32(PC),A0
	LEA	COL0(PC),A6			NARROW POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	CLR.W	LAST_COLOR
	BSR	DO_A_3D_LINE_SPRITE
	CLR.W	LAST_COLOR
	LEA	COL1(PC),A6			NARROW POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	REPT	6
	BSR	DO_A_3D_LINE_SPRITE
	ENDR
	CLR.W	LAST_COLOR
	LEA	COL2(PC),A6			WIDER POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	BSR	DO_A_3D_LINE_SPRITE
	BSR	DO_A_3D_LINE_SPRITE
	REPT	11
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4,A1
	ENDR
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4+4,A1
	RTS

NO_LEFT_LINE:
	LEA	POLY_SURFACES+32(PC),A0
	LEA	COL0(PC),A6			NARROW POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	CLR.W	LAST_COLOR
	BSR	DO_A_3D_LINE_SPRITE1
	CLR.W	LAST_COLOR
	LEA	COL1(PC),A6			NARROW POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	REPT	6
	BSR	DO_A_3D_LINE_SPRITE1
	ENDR
	CLR.W	LAST_COLOR
	LEA	COL2(PC),A6			WIDER POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	BSR	DO_A_3D_LINE_SPRITE1
	BSR	DO_A_3D_LINE_SPRITE1
	ADDQ.W	#4,A1
	ADDQ.W	#1,A2
	REPT	10
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4,A1
	ENDR
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4+4,A1
	RTS

NO_RIGHT_LINE:
	LEA	POLY_SURFACES+32(PC),A0
	LEA	COL0(PC),A6			NARROW POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	CLR.W	LAST_COLOR
	BSR	DO_A_3D_LINE_SPRITE2
	LEA	COL1(PC),A6			NARROW POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	CLR.W	LAST_COLOR
	REPT	6
	BSR	DO_A_3D_LINE_SPRITE2
	ENDR
	CLR.W	LAST_COLOR
	LEA	COL2(PC),A6			WIDER POLY ROUT
	MOVE.L	A6,COL_MOD1+2
	MOVE.L	A6,COL_MOD2+2
	BSR.S	DO_A_3D_LINE_SPRITE2
	BSR.S	DO_A_3D_LINE_SPRITE2
	REPT	10
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4,A1
	ENDR
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADD.W	#4+4+4,A1
	RTS

DO_A_3D_LINE_SPRITE2:
	REPT	10
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4,A1
	ENDR
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADD.W	#4+4+4,A1
	ADD.L	#32-11,A2
	BRA	DO_THE_SPRITES

DO_A_3D_LINE_SPRITE1:
	ADDQ.W	#1,A2
	ADDQ.W	#4,A1
	REPT	10
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4,A1
	ENDR
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4+4,A1
	ADD.L	#32-12,A2
	BRA	DO_THE_SPRITES

DO_A_3D_LINE_SPRITE:
	REPT	11
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4,A1
	ENDR
	TST.B	(A2)+
	BEQ.S	*+6
	BSR	DRAW_3D_SQUARE
	ADDQ.W	#4+4,A1
	ADD.L	#32-12,A2
DO_THE_SPRITES:
	MOVE.L	DRAW_POINT(PC),A3
	SUB.L	#8*(OBS_IN_DRAW_LIST),DRAW_POINT	*LENGTH OF 1 BUFFER
.DRAW_LOOP:
	TST.W	(A3)
	BMI.S	.NO_MORE
	BSR.S	DRAW_SPRITE
	BRA.S	.DRAW_LOOP
.NO_MORE:
	LEA	POLY_SURFACES+32(PC),A0
	RTS

DRAW_POINT:	DC.L	DRAW_LIST9

*************************************************
* THE ROUTINE TO DRAW A SPRITE ON THE LANDSCAPE *
*************************************************

DRAW_SPRITE:
	MOVEQ	#0,D0
	MOVE.L	(A3)+,A6
	MOVE.W	(A3)+,D5			GET X
	MOVE.W	(A3)+,D6			GET Y
	MOVE.W	(A6)+,D7			SPRITE HEIGHT
	SUB.W	D7,D6				SUBTRACT HEIGHT
	SUBQ.W	#1,D7				# LINES -1
	MOVE.L	(A6)+,A5			GET ROUTINE TO USE
	MOVE.L	(A6)+,A0			GET DATA ADDRESS
	MOVE.L	LOGBASE(PC),A6			SCREEN BASE
	BRA	SPRITE_HANDLER			RUN HANDLER

DRAW_SHIP:
	MOVE.W	SHIP_MODE(PC),D0
	BEQ	NORMAL_SHIP
	CMP.W	#2,D0
	BEQ	WAITING_FOR_FADE
EXPLODING_SHIP:
	LEA	EXPLODE_POINT1(PC),A1
	MOVE.W	PROJ_DIVU_TAB+848,D0
	MOVE.L	CURRENT_SHIP_X(PC),D5
	MOVE.L	CURRENT_POS_X(PC),D2
	SUB.L	D2,D5
	SUB.L	#$58000,D5			
	MOVEQ	#10,D7
	LSR.L	D7,D5
	MULS	D0,D5
	SWAP	D5
	MOVE.W	CURRENT_POS_Y(PC),D6
	MOVE.W	D6,D3
	MULS	D0,D6
	SWAP	D6
	ADD.W	#Y_MIDDLE-20,D6
	ADD.W	#136,D5
	MOVE.W	D5,A3
	MOVE.W	D6,A4
	ADDQ.W	#3,A3

	MOVE.L	SHIP_DEATH_POINT(PC),A0
	CMP.L	#SHIP_DEATH_LIST_END,A0
	BEQ.S	.NO_SHIP_DRAW
	ADDQ.L	#4,SHIP_DEATH_POINT
	MOVE.L	(A0),A0				GET SHIP ANI FRAME
	MOVE.L	LOGBASE(PC),A6			SCREEN BASE
	LEA	SPRITE_48(PC),A5		SPRITE ROUT
	MOVEQ	#19,D7				# OF LINES
	BSR	SPRITE_HANDLER
.NO_SHIP_DRAW:
	LEA	SPRITE_16(PC),A5
	BSR	EXPLODING_SUB	
	ADDQ.W	#7,A3
	ADDQ.W	#4,A4
	BSR	EXPLODING_SUB	
	ADD.W	#10,A3
	SUBQ.W	#6,A4
	BSR	EXPLODING_SUB	
	ADDQ.W	#8,A3
	ADDQ.W	#6,A4
	BSR	EXPLODING_SUB	
	SUB.W	#16,A3
	SUBQ.W	#7,A4
	BSR	EXPLODING_SUB	
	TST.W	D0
	BEQ.S	.NOT_ALL_OVER		EXPLOSION IS OVER SO SWITCH SHIP
	MOVE.W	#2,SHIP_MODE		OFF AND FADE OUT
	ST	FADE_OUT
	MOVE.W	#$4EB9,FADE_INSERT
	MOVE.L	#THE_FADE_ROUTINES,FADE_INSERT+2
.NOT_ALL_OVER:
	RTS

WAITING_FOR_FADE:
	TST.B	FADE_OUT
	BNE.S	.NOT_DONE
	MOVE.W	#0,SHIP_MODE			BACK TO NORMAL SHIP
	CLR.W	VEL_OVERRIDE			PLAYER HAS CONTROL
	CLR.W	MOVE_OVERRIDE			
	MOVE.L	#0,TARGET_VELOCITY		START AT 0 SPEED
	MOVE.L	#0,Z_ACC			STOP IT DEAD
	MOVE.L	#SHIP_DEATH_LIST,SHIP_DEATH_POINT	READY FOR NEXT DEATH
	MOVE.W	#111,ENERGY			REPLACE ENERGY
	ST	FADE_IN				FADE COLORS BACK OUT
	MOVE.W	#$4EB9,FADE_INSERT
	MOVE.L	#THE_FADE_ROUTINES,FADE_INSERT+2
	BSR	CLEAR_SCREENS			ERASE DRAW AREA
	BSR	ADD_PLANE1_AND_PANEL		ADD EXTRA GFX TO TOP OF SCREEN
	BSR	GET_SHIP_PRESETS		REPLACE SHIP AT START
	BSR	INIT_OBJECTS			INITIALISE OBJECT LIST
.NOT_DONE:
	RTS

EXPLODING_SUB:
	MOVE.L	(A1)+,A2
	MOVE.L	(A2)+,A0
	CMP.L	#-1,A0
	BEQ.S	.IGNORE_1
	MOVE.L	A2,-4(A1)
	CMP.L	#0,A0
	BEQ.S	.NOTHING_TO_DRAW1
	MOVE.W	A3,D5
	MOVE.W	A4,D6
	MOVEQ	#15,D7
	MOVE.L	LOGBASE(PC),A6
	BSR	SPRITE_HANDLER
.NOTHING_TO_DRAW1:
	MOVEQ	#0,D0
	RTS
.IGNORE_1:
	MOVEQ	#1,D0	
	RTS

EXPLODE_POINT1:	DC.L	EXPLOSION_LIST1+16
EXPLODE_POINT2:	DC.L	EXPLOSION_LIST1+8
EXPLODE_POINT3:	DC.L	EXPLOSION_LIST1+12
EXPLODE_POINT4:	DC.L	EXPLOSION_LIST1+4
EXPLODE_POINT5:	DC.L	EXPLOSION_LIST1

EXPLOSION_POINT_REFILL:
	DC.L	EXPLOSION_LIST1+16,EXPLOSION_LIST1+8
	DC.L	EXPLOSION_LIST1+12,EXPLOSION_LIST1+4
	DC.L	EXPLOSION_LIST1

SHIP_DEATH_POINT:	DC.L	SHIP_DEATH_LIST

SHIP_DEATH_LIST:
	DC.L	SHIP_GRAPHIX2,SHIP_GRAPHIX2
	DC.L	SHIP_GRAPHIX2+(24*20),SHIP_GRAPHIX2+(24*20)
	DC.L	SHIP_GRAPHIX2+(48*20),SHIP_GRAPHIX2+(48*20)
	DC.L	SHIP_GRAPHIX2+(72*20),SHIP_GRAPHIX2+(72*20)
SHIP_DEATH_LIST_END:

NORMAL_SHIP:
*********************COLLISION DETECT FOR SHIP***********************
	MOVE.W	OFFSET_ADDS+6(PC),D7		GET MULU # FOR VERT
	SUBQ.W	#1,D7
	ADD.W	D7,D7
	LSL.W	#8,D7

	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS_Z(PC),D0
	LEA	MAP_ARRAY,A0
	ADD.L	#10,D0
	ADD.L	D0,D0
	ADD.L	D0,A0
	LSL.L	#5,D0
	ADD.L	D0,A0			
	MOVE.L	CURRENT_SHIP_X(PC),D6
	SUB.L	#$A000,D6
	MOVE.L	D6,D0
	CLR.W	D0
	SWAP	D0
	MOVE.L	A0,A1
	ADD.W	D0,D0
	ADD.L	D0,A1

	MOVE.W	2(A1),D1		FIRST POINT
	MOVE.W	(A1),D0
	SUB.W	D0,D1
	LSR.W	#1,D6
	MULS	D6,D1
	ADD.L	D1,D1
	SWAP	D1
	ADD.W	D1,D0

	MOVE.W	-66+2(A1),D3		SECOND POINT
	MOVE.W	-66(A1),D2
	SUB.W	D2,D3
	MULS	D6,D3
	ADD.L	D3,D3
	SWAP	D3
	ADD.W	D3,D2

	SUB.W	D0,D2
	MULS	D7,D2
	ADD.L	D2,D2
	SWAP	D2
	ADD.W	D2,D0

	CMP.W	CURRENT_POS_Y(PC),D0
	BGE.S	.NOT_DEAD1
	SUBQ.W	#5,ENERGY
	BPL.S	.NOT_DEAD1
	BSR	KILL_PLAYER			MAKE HIM DIE!
.NOT_DEAD1:
	MOVE.L	CURRENT_SHIP_X(PC),D6
	ADD.L	#$A000,D6
	MOVE.L	D6,D0
	CLR.W	D0
	SWAP	D0
	MOVE.L	A0,A1
	ADD.W	D0,D0
	ADD.L	D0,A1

	MOVE.W	2(A1),D1		FIRST POINT
	MOVE.W	(A1),D0
	SUB.W	D0,D1
	LSR.W	#1,D6
	MULS	D6,D1
	ADD.L	D1,D1
	SWAP	D1
	ADD.W	D1,D0

	MOVE.W	-66+2(A1),D3		SECOND POINT
	MOVE.W	-66(A1),D2
	SUB.W	D2,D3
	MULS	D6,D3
	ADD.L	D3,D3
	SWAP	D3
	ADD.W	D3,D2

	CMP.W	CURRENT_POS_Y(PC),D0
	BGE.S	.NOT_DEAD2
	SUBQ.W	#5,ENERGY
	BPL.S	.NOT_DEAD2
	BSR	KILL_PLAYER
.NOT_DEAD2:
*********************************************************************
DRAW_ONLY_SHIP:
	MOVE.W	PROJ_DIVU_TAB+848,D0
	MOVE.L	CURRENT_SHIP_X(PC),D5
	MOVE.L	CURRENT_POS_X(PC),D2
	SUB.L	D2,D5
	SUB.L	#$58000,D5			
	MOVEQ	#10,D7
	LSR.L	D7,D5
	MULS	D0,D5
	SWAP	D5
	MOVE.W	CURRENT_POS_Y(PC),D6
	MOVE.W	D6,D3
	MULS	D0,D6
	SWAP	D6
	ADD.W	#Y_MIDDLE-20,D6
	ADD.W	#136,D5

	MOVE.L	CURRENT_X_VEL(PC),D4
	TST.L	D4
	BEQ.S	.VERTICAL_FRAME
	BMI.S	.LEFT_ONES
	CMP.L	#$4000,D4
	BLE.S	.R1
	LEA	SHIP_GRAPHIX+(24*160),A0
	BRA.S	.START
.R1:
	CMP.L	#$2000,D4
	BLE.S	.R2
	LEA	SHIP_GRAPHIX+(24*140),A0
	BRA.S	.START
.R2
	LEA	SHIP_GRAPHIX+(24*40)(PC),A0
	BRA.S	.START
.LEFT_ONES:
	CMP.L	#-$4000,D4
	BGE.S	.L1
	LEA	SHIP_GRAPHIX+(24*100),A0
	BRA.S	.START
.L1:
	CMP.L	#-$2000,D4
	BGE.S	.L2
	LEA	SHIP_GRAPHIX+(24*120),A0
	BRA.S	.START
.L2:	
	LEA	SHIP_GRAPHIX+(24*40)(PC),A0
	BRA.S	.START

.VERTICAL_FRAME:	
	CMP.W	#74,D3
	BGT.S	.1
	LEA	SHIP_GRAPHIX(PC),A0	
	BRA.S	.START
.1	CMP.W	#74+44,D3
	BGT.S	.2
	LEA	SHIP_GRAPHIX+(24*20)(PC),A0
	BRA.S	.START
.2	CMP.W	#74+88,D3
	BGT.S	.3
	LEA	SHIP_GRAPHIX+(24*40)(PC),A0
	BRA.S	.START
.3	CMP.W	#74+132,D3
	BGT.S	.4
	LEA	SHIP_GRAPHIX+(24*60),A0
	BRA.S	.START
.4	LEA	SHIP_GRAPHIX+(24*80),A0
.START:
	MOVE.L	LOGBASE(PC),A6
	LEA	SPRITE_48(PC),A5		SPRITE ROUT
	MOVEQ	#19,D7				# OF LINES
	BRA	SPRITE_HANDLER

ROUTINE_TABLE:
	REPT	4	
	DC.L	NO_RIGHT_LINE
	ENDR
	REPT	56
	DC.L	NORMAL_LINE
	ENDR
	REPT	4	
	DC.L	NO_LEFT_LINE
	ENDR

KILL_PLAYER:
	ST 	VEL_OVERRIDE			TURN OF MANUAL VELOCITY
	ST	MOVE_OVERRIDE			IGNORE JOYSTICK
	MOVE.W	#1,SHIP_MODE			SWITCH TO EXPLOSION
	MOVE.L	#0,TARGET_VELOCITY		SLOW TO A STOP
	MOVE.W	#0,ENERGY
	LEA	EXPLODE_POINT1(PC),A1
	LEA	EXPLOSION_POINT_REFILL(PC),A0
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	MOVE.L	(A0)+,(A1)+
	RTS

************************************************
* OBJECT LIST FORMAT                           *
************************************************
* 0  INITIALISATION ROUTINE
* 4  GENERAL RUNNING ROUTINE
* 8  Y SIZE
* 10 SPRITE ROUTINE TO USE
* 14 GRAPHICS ADDRESS
*
* 58 COLLISION BOX X
* 60 COLLISION BOX Y
*

OBJECT_LIST:
************FIR TREE********************
	DC.L	INIT_GROUND_OBJECTS
	DC.L	GROUND_OBJECTS
	DC.W	16
	DC.L	SPRITE_16,TREE1+(92*8)
	DC.W	18
	DC.L	SPRITE_16,TREE1+(74*8)
	DC.W	22
	DC.L	SPRITE_16,TREE1+(52*8)
	DC.W	25
	DC.L	SPRITE_16,TREE1+(27*8)
	DC.W	27
	DC.L	SPRITE_16,TREE1+(0*8)
	DC.W	32,64,0
************TURRET TYPE1*****************
	DC.L	INIT_GUN_TURRET
	DC.L	TURRET_ROUTINE
	DC.W	14
	DC.L	SPRITE_16,TURRET1+(27*16)+(59*8)
	DC.W	16
	DC.L	SPRITE_16,TURRET1+(27*16)+(43*8)
	DC.W	20
	DC.L	SPRITE_16,TURRET1+(27*16)+(23*8)
	DC.W	23
	DC.L	SPRITE_16,TURRET1+(27*16)
	DC.W	27
	DC.L	SPRITE_32,TURRET1+(0*16)
	DC.W	40,64,0
************LASER GATE LEFT********************
	DC.L	INIT_LASER_GATE
	DC.L	LEFT_LASER_GATE
	DC.W	14
	DC.L	SPRITE_16_TOWER,LASER_GATE+(56*8)
	DC.W	14
	DC.L	SPRITE_16_TOWER,LASER_GATE+(42*8)
	DC.W	14
	DC.L	SPRITE_16_TOWER,LASER_GATE+(28*8)
	DC.W	14
	DC.L	SPRITE_16_TOWER,LASER_GATE+(14*8)
	DC.W	14
	DC.L	SPRITE_16_TOWER,LASER_GATE+(0*8)
	DC.W	40,240,0
**********************************************
	DC.L	NO_OBJECT
	DS.W	30
*************MOVING WALL TYPE1*(UP\DOWN)***********
	DC.L	INIT_MOVING_WALL
	DC.L	MOVING_WALL_ROUTINE
	DC.L	WALL_MOVEMENT1
	DS.W	26
*************MOVING WALL TYPE2*(DOWN\UP)***********
	DC.L	INIT_MOVING_WALL
	DC.L	MOVING_WALL_ROUTINE
	DC.L	WALL_MOVEMENT1B
	DS.W	26
************BUGGY(RIGHT_LEFT)********************
	DC.L	INIT_BUGGY1
	DC.L	BUGGY_ROUTINE
TANK_LEFT:
	DC.W	7
	DC.L	SPRITE_48,TANK2+(48*24)
	DC.W	9
	DC.L	SPRITE_48,TANK2+(39*24)
	DC.W	11
	DC.L	SPRITE_48,TANK2+(28*24)
	DC.W	13
	DC.L	SPRITE_48,TANK2+(15*24)
	DC.W	15
	DC.L	SPRITE_48,TANK2+(0*24)
	DC.W	80,40,0
************BUGGY(DOWN UP)********************
	DC.L	INIT_BUGGY2
	DC.L	BUGGY_ROUTINE
TANK_UP:
	DC.W	7
	DC.L	SPRITE_32,TANK4+(48*16)
	DC.W	9
	DC.L	SPRITE_32,TANK4+(39*16)
	DC.W	11
	DC.L	SPRITE_32,TANK4+(28*16)
	DC.W	13
	DC.L	SPRITE_32,TANK4+(15*16)
	DC.W	15
	DC.L	SPRITE_32,TANK4+(0*16)
	DC.W	64,40,0
************BUGGY(LEFT RIGHT)********************
	DC.L	INIT_BUGGY3
	DC.L	BUGGY_ROUTINE
TANK_RIGHT:
	DC.W	7
	DC.L	SPRITE_48,TANK3+(48*24)
	DC.W	9
	DC.L	SPRITE_48,TANK3+(39*24)
	DC.W	11
	DC.L	SPRITE_48,TANK3+(28*24)
	DC.W	13
	DC.L	SPRITE_48,TANK3+(15*24)
	DC.W	15
	DC.L	SPRITE_48,TANK3+(0*24)
	DC.W	80,40,0
************BUGGY(UP DOWN)********************
	DC.L	INIT_BUGGY4
	DC.L	BUGGY_ROUTINE
TANK_DOWN:
	DC.W	7
	DC.L	SPRITE_32,TANK1+(48*16)
	DC.W	9
	DC.L	SPRITE_32,TANK1+(39*16)
	DC.W	11
	DC.L	SPRITE_32,TANK1+(28*16)
	DC.W	13
	DC.L	SPRITE_32,TANK1+(15*16)
	DC.W	15
	DC.L	SPRITE_32,TANK1+(0*16)
	DC.W	64,40,0
*************ROAD MARKER**********************
	DC.L	NO_OBJECT
	DS.W	30
************LASER_TOWER*******************
	DC.L	INIT_VERTICAL_LASER
	DC.L	VERT_LASER_ROUTINE
	DC.W	6
       	DC.L	SPRITE_32,LASER_TOWER+(37*16)
	DC.W	7
	DC.L	SPRITE_32,LASER_TOWER+(30*16)
	DC.W	9
	DC.L	SPRITE_32,LASER_TOWER+(21*16)
	DC.W	10
	DC.L	SPRITE_32,LASER_TOWER+(11*16)
	DC.W	11
	DC.L	SPRITE_32,LASER_TOWER
	DC.W	64,32,0
*************HIGHLY SPRUNG BUG****************
	DC.L	INIT_SPRING_BUG
	DC.L	SPRING_BUG_ROUTINE
	DC.W	15
	DC.L	SPRITE_16,SPRING_GFX+(85*8)
	DC.W	18
	DC.L	SPRITE_16,SPRING_GFX+(67*8)
	DC.W	20
	DC.L	SPRITE_16,SPRING_GFX+(47*8)
	DC.W	22
	DC.L	SPRITE_16,SPRING_GFX+(25*8)
	DC.W	25
	DC.L	SPRITE_16,SPRING_GFX
	DC.W	40,70,0
*************BASE PROTECTOR****************
	DC.L	INIT_BASE
	DC.L	BASE_ROUTINE
	DC.W	8
	DC.L	SPRITE_32,BASE_GFX+(52*16)
	DC.W	10
	DC.L	SPRITE_32,BASE_GFX+(42*16)
	DC.W	12
	DC.L	SPRITE_32,BASE_GFX+(30*16)
	DC.W	14
	DC.L	SPRITE_32,BASE_GFX+(16*16)
	DC.W	16
	DC.L	SPRITE_32,BASE_GFX
	DC.W	64,32,0
*************SHOOTABLE WALL*********
	DC.L	INIT_SHOOTABLE_WALL
	DC.L	SHOOTABLE_WALL_ROUTINE
	DS.W	25
	DC.W	64,268,0
****************MINE LAYER***************
	DC.L	INIT_MINE_LAYER
	DC.L	MINE_LAYER_ROUTINE
MINE_LAYER_LEFT:
	DC.W	6
	DC.L	SPRITE_48,MINE_LAYER_L+(44*24)
	DC.W	8
	DC.L	SPRITE_48,MINE_LAYER_L+(36*24)
	DC.W	10
	DC.L	SPRITE_48,MINE_LAYER_L+(26*24)
	DC.W	12
	DC.L	SPRITE_48,MINE_LAYER_L+(14*24)
	DC.W	14
	DC.L	SPRITE_48,MINE_LAYER_L
	DC.W	64,32,0
***********VELOCITY OVERRIDE*************
	DC.L	INIT_VELOCITY_OVERRIDE
	DS.W	30
***********RETURN TO PLAYER CONTROL******
	DC.L	REMOVE_VELOCITY_OVERRIDE
	DS.W	30
************MOVING TURRET (LEFT/RIGHT)***
	DC.L	INIT_MOVING_GUN
	DC.L	MOVING_GUN_ROUTINE
GUN_GRAPHIX:
	DC.W	14
	DC.L	SPRITE_16,TURRET1+(27*16)+(59*8)
	DC.W	16
	DC.L	SPRITE_16,TURRET1+(27*16)+(43*8)
	DC.W	20
	DC.L	SPRITE_16,TURRET1+(27*16)+(23*8)
	DC.W	23
	DC.L	SPRITE_16,TURRET1+(27*16)
	DC.W	27
	DC.L	SPRITE_32,TURRET1+(0*16)
	DC.W	40,64,0
*************WAVER************************
	DC.L	INIT_WAVER
	DC.L	WAVER_ROUTINE
	DC.W	7
	DC.L	SPRITE_48,WAVER_GFX+(44*24)
	DC.W	8
	DC.L	SPRITE_48,WAVER_GFX+(36*24)
	DC.W	10
	DC.L	SPRITE_48,WAVER_GFX+(26*24)
	DC.W	12
	DC.L	SPRITE_48,WAVER_GFX+(14*24)
	DC.W	14
	DC.L	SPRITE_48,WAVER_GFX
	DC.W	85,50,0
*************SAUCER************************
	DC.L	NO_OBJECT
	DC.L	SAUCER_ROUTINE
SAUCER_DEFINITION:
	DC.W	3
	DC.L	SPRITE_16,SAUCER_GFX+(22*8)
	DC.W	4
	DC.L	SPRITE_16,SAUCER_GFX+(18*8)
	DC.W	5
	DC.L	SPRITE_16,SAUCER_GFX+(13*8)
	DC.W	6
	DC.L	SPRITE_16,SAUCER_GFX+(7*8)
	DC.W	7
	DC.L	SPRITE_16,SAUCER_GFX
	DC.W	26,20,0
*************SPACE INVADER COMMANDER***********
	DC.L	INIT_SI_COMMANDER
	DC.L	SI_COMMANDER_ROUTINE
	DS.W	28
***************SPACE INVADER***********************
	DC.L	NO_OBJECT
	DC.L	SI_ROUTINE
SI_DEFINITION:
	DC.W	10
	DC.L	SPRITE_16,DUMMY_GFX+(55*8)
	DC.W	12
	DC.L	SPRITE_16,DUMMY_GFX+(43*8)
	DC.W	13
	DC.L	SPRITE_16,DUMMY_GFX+(30*8)
	DC.W	14
	DC.L	SPRITE_16,DUMMY_GFX+(16*8)
	DC.W	16
	DC.L	SPRITE_16,DUMMY_GFX
	DC.W	50,50,0

MISSILE_LIST:
************MISSILE TYPE 1****************
	DC.W	4
	DC.L	SPRITE_16,MISSILE1+(20*8)
	DC.W	4
	DC.L	SPRITE_16,MISSILE1+(16*8)
	DC.W	4
	DC.L	SPRITE_16,MISSILE1+(12*8)
	DC.W	6
	DC.L	SPRITE_16,MISSILE1+(6*8)
	DC.W	6
	DC.L	SPRITE_16,MISSILE1+(0*8)

BULLET_LIST:
************BULLET TYPE 1****************
	DC.W	4
	DC.L	SPRITE_16,BULLET1+(26*8)
	DC.W	5
	DC.L	SPRITE_16,BULLET1+(21*8)
	DC.W	6
	DC.L	SPRITE_16,BULLET1+(15*8)
 	DC.W	7
	DC.L	SPRITE_16,BULLET1+(8*8)
	DC.W	8
	DC.L	SPRITE_16,BULLET1+(0*8)

VERT_LASER_LIST:
************VERTICAL LASER**************
	DC.W	14
	DC.L	SPRITE_16_LASER,VERTICAL_LASER+(56*8)
 	DC.W	14
	DC.L	SPRITE_16_LASER,VERTICAL_LASER+(42*8)
	DC.W	14
	DC.L	SPRITE_16_LASER,VERTICAL_LASER+(28*8)
 	DC.W	14
	DC.L	SPRITE_16_LASER,VERTICAL_LASER+(14*8)
	DC.W	14
	DC.L	SPRITE_16_LASER,VERTICAL_LASER

PARACHUTE_LIST:
************PARACHUTE MINE**************
	DC.W	3
	DC.L	SPRITE_16,MINE_GFX+(26*8)
 	DC.W	5
	DC.L	SPRITE_16,MINE_GFX+(21*8)
	DC.W	6
	DC.L	SPRITE_16,MINE_GFX+(15*8)
 	DC.W	7
	DC.L	SPRITE_16,MINE_GFX+(8*8)
	DC.W	8
	DC.L	SPRITE_16,MINE_GFX
	DC.W	32,32,0

LASER_LINE:				
***********DATA FOR LASER BEAMS ON THE GATES********
	DC.W	0		
	DC.L	HORIZONTAL_LINE
	DC.W	0,0

****************MINE LAYER***************
MINE_LAYER_RIGHT:
	DC.W	6
	DC.L	SPRITE_48,MINE_LAYER_R+(44*24)
	DC.W	8
	DC.L	SPRITE_48,MINE_LAYER_R+(36*24)
	DC.W	10
	DC.L	SPRITE_48,MINE_LAYER_R+(26*24)
	DC.W	12
	DC.L	SPRITE_48,MINE_LAYER_R+(14*24)
	DC.W	14
	DC.L	SPRITE_48,MINE_LAYER_R
	DC.W	64,32,0

*************BASE PROTECTOR (DEAD)****************
BASE_DEAD:
	DC.W	7
	DC.L	SPRITE_32,BASE_DEAD_GFX+(46*16)
	DC.W	8
	DC.L	SPRITE_32,BASE_DEAD_GFX+(38*16)
	DC.W	10
	DC.L	SPRITE_32,BASE_DEAD_GFX+(28*16)
	DC.W	12
	DC.L	SPRITE_32,BASE_DEAD_GFX+(16*16)
	DC.W	16
	DC.L	SPRITE_32,BASE_DEAD_GFX
	DC.W	64,32,0
*************SHOOTABLE WALL*********

***********************************************
* ROUTINES TO KEEP TRACK OF MOVING OBJECTS IN *
* THE GAME                                    *
***********************************************

LAST_MAP_POS:		DC.W	$1A3
LAST_Z_MOVEMENT:	DC.L	0
CURRENT_START_Z:	DC.W	0

MOVE_ALL_OBJECTS:
	MOVE.L	#MISSILE_INFORMATION+4,MISSILE_INFORMATION	REFILL MISSILE POINTERS
	MOVE.L	#COLLISION_INFORMATION+4,COLLISION_INFORMATION	REFILL COLLIDE POINTERS
	MOVE.L	LAST_Z_MOVEMENT(PC),D5
	MOVEQ	#10,D4
	LSR.L	D4,D5			
	MOVE.W	D5,LAST_Z_MOVEMENT
	BSR.S	GET_NEW_OBJECTS
	LEA	DP1,A0			RESET ALL DEPTH POINTERS
	LEA	DP_LIST(PC),A1
	REPT	9			
	MOVE.L	(A1)+,(A0)+
	ENDR
	BSR	MAKE_MOVEMENTS
	LEA	DP1,A0
	MOVEQ	#-1,D0
	REPT	9
	MOVE.L	(A0)+,A1
	MOVE.W	D0,(A1)
	ENDR
	BSR	CHECK_FOR_HITS
	RTS

DP_LIST:	DC.L	DRAW_LIST1
		DC.L	DRAW_LIST2
		DC.L	DRAW_LIST3
		DC.L	DRAW_LIST4
		DC.L	DRAW_LIST5
		DC.L	DRAW_LIST6
		DC.L	DRAW_LIST7
		DC.L	DRAW_LIST8
		DC.L	DRAW_LIST9

GET_NEW_OBJECTS:
	LEA	THINGS_TO_DO_LIST(PC),A1
	MOVEQ	#0,D0
	MOVE.W	CURRENT_POS_Z(PC),D0
	CMP.W	LAST_MAP_POS(PC),D0
	BEQ.S	.NO_EXTRA_OBJECTS
	MOVE.W	D0,LAST_MAP_POS
	SUBQ.W	#2,D0
	BPL.S	.OK
	ADD.W	#512,D0
.OK:
	MOVE.W	D0,D1
	LSL.L	#5,D0
	LEA	OBJECT_ARRAY,A0
	ADD.W	D0,A0				GET POS IN OBJECT LIST
	LEA	MAP_ARRAY+66,A4
	MULU	#66,D1
	ADD.L	D1,A4	
	MOVE.W	CURRENT_START_Z(PC),D6
	SUB.W	LAST_Z_MOVEMENT(PC),D6		ADD IT TO BASE Z
	SUB.W	#424-128,D6			OFFSET TO FRONT OF PROJDIVU
	MOVEQ	#0,D5
	MOVEQ	#31,D7
.LOOP:
	TST.B	(A0)+
	BEQ.S	.NO_ITEM
.FIND_SLOT_LOOP:
	TST.W	(A1)			IS OBJECT SLOT FREE?
	BPL.S	.NEXT_SLOT		NOPE!
	MOVE.L	2(A1),A2		GET SLOT DATA POS
	MOVEQ	#0,D0
	MOVE.B	-1(A0),D0
	LSL.W	#6,D0
	LEA	OBJECT_LIST-64(PC),A3
	ADD.L	D0,A3
	MOVE.L	(A3)+,A5		TELL IT WHAT ROUTINE TO USE
	JSR	(A5)
	BRA.S	.NO_ITEM
.NEXT_SLOT:
	ADDQ.L	#6,A1
	BRA.S	.FIND_SLOT_LOOP	
.NO_ITEM:
	ADD.W	#64,D5
	ADDQ.W	#2,A4			
	DBF	D7,.LOOP
.NO_EXTRA_OBJECTS:
	MOVE.L	A1,THINGS_TO_DO_LIST_POINT
	RTS

MAKE_MOVEMENTS:
	LEA	PROJ_DIVU_TAB+848,A0
	LEA	THINGS_TO_DO_LIST(PC),A1
	LEA	DP1,A3
	LEA	DEPTH_LIST(PC),A5
	MOVEQ	#10,D4
	MOVE.L	CURRENT_POS_X(PC),D5
	MOVE.W	LAST_Z_MOVEMENT(PC),D6
	ASR.L	D4,D5

	REPT	MAX_ITEMS
	TST.W	(A1)+
	BMI.S	*+8
	MOVE.L	(A1),A2
	MOVE.L	(A2)+,A6
	JSR	(A6)
	ADDQ.W	#4,A1
	ENDR
	RTS

DEPTH_LIST:	DC.W	40,30,30,20,20,10,10,0,0,0

***************************************
* THE ROUTINE TO CHECK IF PLAYER SHOT *
* ANYTHING!                           *
* AND TO SEE IF HE GOT HIT BY ANYTHING*
***************************************

CHECK_FOR_HITS:
***********FIRST HAS HE SHOT ANYTHING************
	LEA	MISSILE_INFORMATION,A0		LIST OF MISSILES
	MOVE.L	(A0)+,A1			PUT END MARKER
	MOVE.W	#-1,(A1)	
	LEA	THINGS_TO_DO_LIST(PC),A2	LIST OF ENEMIES
	MOVEQ	#MAX_ITEMS-1,D7	
.HIT_LOOP:
	TST.W	(A2)+				IS SLOT USED
	BMI.S	.EMPTY				NOPE!
	MOVE.L	(A2),A3
	TST.B	31(A3)				CAN IT BE SHOT?
	BEQ.S	.EMPTY
	MOVE.L	A0,A4				GET START OF MISSILE_LIST
	MOVE.W	12(A3),D0			GET Z OF ENEMY
.DETECT_LOOP:
	TST.W	(A4)
	BMI.S	.EMPTY
	MOVE.W	D0,D1
	SUB.W	8(A4),D1
	CMP.W	#64,D1				AT CORRECT DEPTH?
	BHI.S	.MISSED
	MOVE.L	4(A3),A5			AT CORRECT X?
	MOVE.W	4(A4),D2
	SUB.W	8(A3),D2
	CMP.W	58-8(A5),D2
	BHI.S	.MISSED
	MOVE.W	10(A3),D2			AT CORRECT Y?
	SUB.W	6(A4),D2
	CMP.W	60-8(A5),D2
	BHI.S	.MISSED
	MOVE.L	(A4),A5				GET POS IN THINGS TO DO LIST
	MOVE.W	#-1,-2(A5)			REMOVE BULLET
	ST	30(A3)				KILL OBJECT!
.MISSED:
	LEA	10(A4),A4
	BRA.S	.DETECT_LOOP

.EMPTY:	ADDQ.W	#4,A2
	DBF	D7,.HIT_LOOP

**********AND NOW HAS HE BEEN SHOT BY ANYTHING***********
	TST.W	SHIP_MODE
	BNE.S	.NOT_DEAD_YET
	LEA	COLLISION_INFORMATION,A0	LIST OF MISSILES
	MOVE.L	(A0)+,A1			PUT END MARKER
	MOVE.W	#-1,(A1)	
	MOVE.L	CURRENT_SHIP_X(PC),D0		D0 = X
	MOVEQ	#10,D1
	LSR.L	D1,D0
	SUB.W	#64,D0				ADJUST FOR LEFT EDGE
	MOVE.W	CURRENT_POS_Y(PC),D1		D1 = Y
.COLL_LOOP:
	TST.W	(A0)
	BMI.S	.NO_MORE_TESTS
	MOVE.W	(A0),D2

	SUB.W	D0,D2			
	BPL.S	.OB_TO_RIGHT
	MOVE.W	2(A0),D3
	ADD.W	D3,D2
 	ADD.W	#80,D3				X_SIZE	
	CMP.W	D3,D2
	BHI.S	.NO_HIT
	BRA.S	.DO_VERT
.OB_TO_RIGHT		
	CMP.W	#80,D2
	BGE.S	.NO_HIT
.DO_VERT:
	MOVE.W	4(A0),D2
	SUB.W	D1,D2
	BMI.S	.OBJECT_ABOVE
	MOVE.W	6(A0),D3
	SUB.W	D3,D2
	BPL.S	.NO_HIT
	ADD.W	#40,D3
	NEG.W	D3
	CMP.W	D3,D2
	BLT.S	.NO_HIT
	BRA.S	.HE_HIT_HIM		
.OBJECT_ABOVE
	CMP.W	#-40,D2				Y_SIZE
	BLT.S	.NO_HIT
.HE_HIT_HIM:
	MOVE.W	8(A0),D2
	SUB.W	D2,ENERGY			LOSES SOME ENERGY
.NO_HIT:
	LEA	10(A0),A0
	BRA.S	.COLL_LOOP
.NO_MORE_TESTS:	
	TST.W	ENERGY
	BPL.S	.NOT_DEAD_YET
	BSR	KILL_PLAYER
.NOT_DEAD_YET:
	RTS

***************************************************
* THIS LITTLE ROUTINE PUTS ON THE CURRENT OBJECTS *
* WHEN A NEW MAP IS STARTED                       *
***************************************************

INIT_OBJECTS:
	LEA	THINGS_TO_DO_LIST(PC),A0
	MOVEQ	#MAX_ITEMS-1,D7
.LOOPC:	MOVE.W	#-1,(A0)
	ADDQ.W	#6,A0
	DBF	D7,.LOOPC

	MOVE.W	CURRENT_POS_Z(PC),D0
	ADD.W	#10,CURRENT_POS_Z
	MOVE.W	#937-(10*64),D6
	MOVE.L	#0,LAST_Z_MOVEMENT
	MOVEQ	#10,D7
.LOOP:	MOVE.W	D6,CURRENT_START_Z
	ADD.W	#64,D6
	MOVEM.L	D6-D7,-(A7)
	BSR	GET_NEW_OBJECTS
	MOVEM.L	(A7)+,D6-D7
	SUBQ.W	#1,CURRENT_POS_Z
	DBF	D7,.LOOP
	ADDQ.W	#1,CURRENT_POS_Z
	RTS

THINGS_TO_DO_LIST_POINT:
	DC.L	THINGS_TO_DO_LIST

THINGS_TO_DO_LIST:
	
ADDIT	SET	0
	REPT	MAX_ITEMS
	DC.W	-1
	DC.L	THINGS_TO_DO_DATA+ADDIT
ADDIT	SET	ADDIT+32
	ENDR

LOGBASE:
	DC.L	SCREEN1
	DC.L	SCREEN2
	DC.L	SCREEN3

*********************************************************
* ALL SORTS OF STRANGE AND WEIRD SUBROUTINES            *
*********************************************************
					
	INCLUDE	N:\LANDGAME.TLB\OBJECT.LOG\LOGIC.S
	INCLUDE	N:\LANDGAME.TLB\POLYGONS\POLYGON1.S
	INCLUDE	N:\LANDGAME.TLB\POLYGONS\POLYGON2.S
	INCLUDE	N:\LANDGAME.TLB\POLYGONS\POLYGON3.S
	INCLUDE	N:\LANDGAME.TLB\SPRITES\SPRITE_1.S

POLYGON_IMG:	DS.W	400

*******************************************************
* ANIMATION TABLES FOR EXPLOSION DATA                 *
*******************************************************

EXPLOSION_LIST1:
	DC.L	0,0,0,0,0,0
	DC.L	EXPLOSION1+0
	DC.L	EXPLOSION1+128
	DC.L	EXPLOSION1+256
	DC.L	EXPLOSION1+384
	DC.L	EXPLOSION1+512
	DC.L	EXPLOSION1+640
	DC.L	EXPLOSION1+768
	DC.L	EXPLOSION1+896
	DC.L	-1

EXPLOSION_LIST2:
	DC.L	0,0,0,0,0,0
	DC.L	EXPLOSION2+0
	DC.L	EXPLOSION2+384
	DC.L	EXPLOSION2+768
	DC.L	EXPLOSION2+1152
	DC.L	EXPLOSION2+1536
	DC.L	EXPLOSION2+1920
	DC.L	EXPLOSION2+2304
	DC.L	-1

*****************************************
* TEXT HANDLING ROUTINE                 *
* A0 = TEXT TO PRINT                    *
* A1 = SCREEN ADDRESS                   *
*****************************************

BYTE_IND:	DC.W	0		*ODD OR EVEN BYTE

PRINT_TEXT:
	LEA	FONT_8,A2
	MOVE.L	A1,A3			COPY LINE ADDRESS
	CLR.W	BYTE_IND
.PRINT_LOOP:
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	CMP.B	#32,D0
	BGE.S	.NORMAL_CHAR
	TST.B	D0
	BEQ.S	.FINISHED_PRINTING
	CMP.B	#13,D0
	BNE.S	.NOT_LINEFEED
	LEA	8*160(A1),A1
	MOVE.L	A1,A3
	MOVE.W	#0,BYTE_IND
.NOT_LINEFEED:
	BRA.S	.PRINT_LOOP
.NORMAL_CHAR:
	SUB.W	#32,D0
	LSL.W	#6,D0
	LEA	(A2,D0.W),A4
	NOT.W	BYTE_IND
	BEQ.S	.EVEN
.ODD:
	BSR.S	DRAW_CHAR
	LEA	1(A3),A3
	BRA.S	.PRINTED_IT
.EVEN:
	BSR.S	DRAW_CHAR
	LEA	7(A3),A3
.PRINTED_IT:
	BRA.S	.PRINT_LOOP
.FINISHED_PRINTING:
	RTS

DRAW_CHAR:
	MOVE.L	A3,-(A7)
	MOVEQ	#7,D7
.PRINT_LOOP:
	MOVE.B	(A4),(A3)
	MOVE.B	2(A4),2(A3)
	MOVE.B	4(A4),4(A3)
	MOVE.B	6(A4),6(A3)
	LEA	8(A4),A4
	LEA	160(A3),A3
	DBF	D7,.PRINT_LOOP
	MOVE.L	(A7)+,A3
	RTS

HELLO_TEXT:
	DC.B	13			
	DC.B	13			
	DC.B	13			
	DC.B	13			
	DC.B	"              KILLING SPREE",13			
	DC.B	13			
	DC.B	"          BY TIM AND DAVE MOSS",13			
	DC.B	13			
	DC.B	"(C) COPYRIGHT 1991 LOST BOYS DEVELOPMENT",13			
	DC.B	13			
	DC.B	"       THIS VERSION  18 - 12 - 91",13			
	DC.B	13			
	DC.B	"  'WHEN LIFE GETS YOU DOWN, COUNT YOUR",13
	DC.B	"    LUCKY STARS THAT YOUR NOT A DWARF",13			
	DC.B	"      WITH IN GROWING TOENAILS AND",13			
	DC.B	"            A 3 INCH PENIS!'",0	
	EVEN

*********************************************************
* GRAPHIX AND STUFF FOR THE GAME OBJECTS                *
*********************************************************
 
SHIP_GRAPHIX:	INCBIN	N:\LANDGAME.TLB\DATA\SHIP.OBJ
SHIP_GRAPHIX2:	INCBIN	N:\LANDGAME.TLB\DATA\SHIP_DIE.OBJ
TREE1:		INCBIN	N:\LANDGAME.TLB\DATA\TREE1.OBJ
TURRET1:	INCBIN	N:\LANDGAME.TLB\DATA\TURRETS.OBJ
TANK1:		INCBIN	N:\LANDGAME.TLB\DATA\TANK_D.OBJ
TANK2:		INCBIN	N:\LANDGAME.TLB\DATA\TANK_L.OBJ
TANK3:		INCBIN	N:\LANDGAME.TLB\DATA\TANK_R.OBJ
TANK4:		INCBIN	N:\LANDGAME.TLB\DATA\TANK_U.OBJ
LASER_TOWER:	INCBIN	N:\LANDGAME.TLB\DATA\LAS_TOWR.OBJ
LASER_GATE:	INCBIN	N:\LANDGAME.TLB\DATA\LAZ_GATE.OBJ
MISSILE1:	INCBIN	N:\LANDGAME.TLB\DATA\MISSILE1.OBJ
BULLET1:	INCBIN	N:\LANDGAME.TLB\DATA\BULLET1.OBJ
VERTICAL_LASER:	INCBIN	N:\LANDGAME.TLB\DATA\LAS_VERT.OBJ
EXPLOSION1:	INCBIN	N:\LANDGAME.TLB\DATA\EXPLODE1.OBJ
EXPLOSION2:	INCBIN	N:\LANDGAME.TLB\DATA\EXPLODE2.OBJ
DUMMY_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\DUMMY.OBJ
BASE_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\BASE.OBJ
BASE_DEAD_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\BASEDEAD.OBJ
MINE_LAYER_L:	INCBIN	N:\LANDGAME.TLB\DATA\ML_LEFT.OBJ
MINE_LAYER_R:	INCBIN	N:\LANDGAME.TLB\DATA\ML_RIGHT.OBJ
MINE_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\MINE.OBJ
SAUCER_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\SAUCER.OBJ
SPRING_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\SPRING.OBJ
WAVER_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\WAVER.OBJ

PANEL_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\PANEL.OBJ
SCORE_PANEL_GX:	INCBIN	N:\LANDGAME.TLB\DATA\PANEL_SC.OBJ
FONT_8:		INCBIN	N:\LANDGAME.TLB\DATA\FONT.OBJ
PANEL_IND_GFX:	INCBIN	N:\LANDGAME.TLB\DATA\PANEL_IN.OBJ
NUMBERS_6:	INCBIN	N:\LANDGAME.TLB\DATA\NUMBERS.OBJ
PANEL_ENERGY:	INCBIN	N:\LANDGAME.TLB\DATA\PANEL_EG.OBJ

	SECTION	BSS

		DS.L	100
OURSTACK:	DS.L	10	

DRAW_BUFFER:	DS.W	13*11*2

PROJ_DIVU_TAB:	DS.W	1200

MISSILE_INFORMATION:
		DS.L	1
		DS.W	5*MAX_ITEMS
COLLISION_INFORMATION:
		DS.L	1
		DS.W	4*MAX_ITEMS

THINGS_TO_DO_DATA:
	DS.W	16*MAX_ITEMS		MAX 30 OBJECTS SO FAR!

DP1:		DS.L	9
DRAW_LIST1:	DS.W	(2+2)*OBS_IN_DRAW_LIST	
DRAW_LIST2:	DS.W	(2+2)*OBS_IN_DRAW_LIST		
DRAW_LIST3:	DS.W	(2+2)*OBS_IN_DRAW_LIST		
DRAW_LIST4:	DS.W	(2+2)*OBS_IN_DRAW_LIST		
DRAW_LIST5:	DS.W	(2+2)*OBS_IN_DRAW_LIST		
DRAW_LIST6:	DS.W	(2+2)*OBS_IN_DRAW_LIST		
DRAW_LIST7:	DS.W	(2+2)*OBS_IN_DRAW_LIST		
DRAW_LIST8:	DS.W	(2+2)*OBS_IN_DRAW_LIST		
DRAW_LIST9:	DS.W	(2+2)*OBS_IN_DRAW_LIST		

MAP_ARRAY:	DS.W	(((GRID_SIZE+1)*GRID_SIZE)*16)+GRID_SIZE+1
MAP_ARRAY_END:
		DS.W	(GRID_SIZE+1)*GRID_SIZE			*OVERLAP AREA FOR MAP
COLOR_ARRAY:	DS.B	((GRID_SIZE*GRID_SIZE)*16)+GRID_SIZE
COLOR_ARRAY_END:
		DS.B	GRID_SIZE*GRID_SIZE
		EVEN
OBJECT_ARRAY:	DS.B	((GRID_SIZE*GRID_SIZE)*16)+GRID_SIZE
OBJECT_ARRAY_END:

GRID_MULT_TABLE:
		DS.L	(GRID_SIZE*16)+1
GRID_MULT_TABLE_END:
MAP_IN_2D:	DS.B	16*(512+32)
DATA_BUFFER: